/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.info;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataOwner;
import es.bsc.compss.types.data.params.StreamData;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class StreamInfo
extends DataInfo<StreamData> {
    private final List<AbstractTask> streamWriters = new ArrayList<AbstractTask>();

    public StreamInfo(StreamData stream, DataOwner owner) {
        super(stream, owner);
        int code = stream.getCode();
        owner.registerObjectData(code, this);
    }

    public int getCode() {
        return ((StreamData)this.getParams()).getCode();
    }

    @Override
    public EngineDataAccessId willAccess(AccessParams.AccessMode mode) {
        EngineDataAccessId daId;
        switch (mode) {
            case R: {
                this.currentVersionWillBeRead();
                daId = new RAccessId(this, this.currentVersion);
                break;
            }
            case W: {
                this.currentVersionWillBeWritten();
                daId = new WAccessId(this, this.currentVersion);
                break;
            }
            default: {
                ErrorManager.warn("Unsupported type of access (" + (Object)((Object)mode) + ") for stream " + this.dataId);
                daId = null;
            }
        }
        return daId;
    }

    @Override
    public void waitForDataReadyToDelete(Semaphore sem) {
    }

    @Override
    public AbstractTask getLastVersionProducer() {
        if (!this.streamWriters.isEmpty()) {
            return this.streamWriters.get(0);
        }
        return null;
    }

    @Override
    public void completedProducer(AbstractTask task) {
        this.streamWriters.remove(task);
    }

    @Override
    public boolean readValue(Task task, DependencyParameter dp, boolean isConcurrent) {
        int dataId = dp.getDataAccessId().getDataId();
        if (!this.streamWriters.isEmpty()) {
            if (DEBUG) {
                StringBuilder sb = new StringBuilder();
                if (this.streamWriters.size() > 1) {
                    sb.append("Last writers for stream datum ").append(dataId).append(" are tasks ");
                } else {
                    sb.append("Last writer for stream datum ").append(dataId).append(" is task ");
                }
                for (AbstractTask lastWriter : this.streamWriters) {
                    sb.append(lastWriter.getId());
                    sb.append(" ");
                }
                LOGGER.debug(sb.toString());
            }
            for (AbstractTask lastWriter : this.streamWriters) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream dependency between task " + lastWriter.getId() + " and task " + task.getId());
                }
                task.addStreamDataDependency(lastWriter);
            }
        } else if (DEBUG) {
            LOGGER.debug("There is no last stream writer for datum " + dataId);
        }
        Application app = task.getApplication();
        app.getGH().addStreamDependency(task, dataId, false);
        return true;
    }

    @Override
    public void writeValue(Task t, DependencyParameter dp, boolean isConcurrent) {
        this.streamWriters.add(t);
        Integer dataId = dp.getDataAccessId().getDataId();
        Application app = t.getApplication();
        app.getGH().addStreamDependency(t, dataId, true);
    }

    @Override
    public void mainAccess(RegisterDataAccessRequest rdar, EngineDataAccessId access) {
        EngineDataInstanceId accessedData = access.isWrite() ? ((EngineDataAccessId.WritingDataAccessId)((Object)access)).getWrittenDataInstance() : ((EngineDataAccessId.ReadingDataAccessId)((Object)access)).getReadDataInstance();
        Application app = rdar.getAccess().getApp();
        for (AbstractTask lastWriter : this.streamWriters) {
            app.getGH().mainAccessToData(lastWriter, EdgeType.STREAM_DEPENDENCY, accessedData);
        }
    }

    @Override
    public List<AbstractTask> getDataWriters() {
        return this.streamWriters;
    }
}

