/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.FileInfo;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.params.DataOwner;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.util.FileOpsManager;
import java.io.File;

public class FileData
extends DataParams {
    protected final String locKey;
    private final DataLocation loc;

    public FileData(DataLocation loc) {
        this.loc = loc;
        this.locKey = loc.getLocationKey();
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    public String getLocationKey() {
        return this.locKey;
    }

    @Override
    public String getDescription() {
        return "file " + this.locKey;
    }

    @Override
    protected DataInfo registerData(DataOwner owner) {
        FileInfo dInfo = new FileInfo(this, owner);
        return dInfo;
    }

    @Override
    public DataInfo getRegisteredData(DataOwner owner) {
        String locationKey = this.loc.getLocationKey();
        return owner.getFileData(locationKey);
    }

    @Override
    protected DataInfo unregisterData(DataOwner owner) throws ValueUnawareRuntimeException {
        String locationKey = this.loc.getLocationKey();
        return owner.removeFileData(locationKey);
    }

    @Override
    public void deleteLocal() throws Exception {
        String filePath = this.getLocation().getURIInHost(Comm.getAppHost()).getPath();
        File f = new File(filePath);
        FileOpsManager.deleteSync(f);
    }
}

