/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class AlreadyAccessedRequest
implements APRequest {
    private final Application app;
    private final DataParams data;
    private final Semaphore sem;
    private boolean response;

    public AlreadyAccessedRequest(Application app, DataParams data) {
        this.app = app;
        this.sem = new Semaphore(0);
        this.data = data;
    }

    public DataParams getData() {
        return this.data;
    }

    public final boolean getResponse() {
        this.sem.acquireUninterruptibly();
        return this.response;
    }

    @Override
    public void process(AccessProcessor ap, TaskDispatcher td) {
        LOGGER.debug("Check already accessed: " + this.data.getDescription());
        DataInfo dInfo = this.data.getRegisteredData(this.app);
        this.response = dInfo != null;
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.ALREADY_ACCESSED;
    }
}

