/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class DataGetLastVersionRequest
implements APRequest {
    private final Semaphore sem;
    private final Application app;
    private final DataParams data;
    private LogicalData response;

    public DataGetLastVersionRequest(Application app, DataParams data) {
        this.app = app;
        this.sem = new Semaphore(0);
        this.data = data;
    }

    public LogicalData getData() {
        this.sem.acquireUninterruptibly();
        return this.response;
    }

    @Override
    public void process(AccessProcessor ap, TaskDispatcher td) {
        this.response = null;
        DataInfo dInfo = this.data.getRegisteredData(this.app);
        if (dInfo != null) {
            this.response = dInfo.getCurrentDataVersion().getDataInstanceId().getData();
        }
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.AP_GET_LAST_DATA;
    }
}

