/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudImageManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.CloudManager");
    private Map<String, CloudImageDescription> images;

    public CloudImageManager() {
        LOGGER.debug("Initializing CloudImageManager");
        this.images = new HashMap<String, CloudImageDescription>();
    }

    public void add(CloudImageDescription cid) {
        LOGGER.debug("Add new Image description " + cid.getImageName());
        this.images.put(cid.getImageName(), cid);
    }

    public List<CloudImageDescription> getCompatibleImages(MethodResourceDescription requested) {
        LinkedList<CloudImageDescription> compatiblesList = new LinkedList<CloudImageDescription>();
        for (CloudImageDescription cid : this.images.values()) {
            String imageOSType = cid.getOperatingSystemType();
            String reqOSType = requested.getOperatingSystemType();
            if (!imageOSType.equals("[unassigned]") && !reqOSType.equals("[unassigned]") && !imageOSType.equals(reqOSType)) continue;
            String imageOSDistr = cid.getOperatingSystemDistribution();
            String reqOSDistr = requested.getOperatingSystemDistribution();
            if (!imageOSDistr.equals("[unassigned]") && !reqOSDistr.equals("[unassigned]") && !imageOSDistr.equals(reqOSDistr)) continue;
            String imageOSVersion = cid.getOperatingSystemVersion();
            String reqOSVersion = requested.getOperatingSystemVersion();
            if (!imageOSVersion.equals("[unassigned]") && !reqOSVersion.equals("[unassigned]") && !imageOSVersion.equals(reqOSVersion) || !cid.getAppSoftware().containsAll(requested.getAppSoftware())) continue;
            List<String> reqQueues = requested.getHostQueues();
            List<String> imageQueues = cid.getQueues();
            if (!reqQueues.isEmpty() && Collections.disjoint(reqQueues, imageQueues)) continue;
            compatiblesList.add(cid);
        }
        return compatiblesList;
    }

    public CloudImageDescription getImage(String name) {
        return this.images.get(name);
    }

    public Set<String> getAllImageNames() {
        return this.images.keySet();
    }

    public Collection<CloudImageDescription> getAllImages() {
        return this.images.values();
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("IMAGES = [").append("\n");
        for (Map.Entry<String, CloudImageDescription> image : this.images.entrySet()) {
            String imageName = image.getKey();
            sb.append(prefix).append("\t").append("IMAGE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("NAME = ").append(imageName).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

