/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;

public class TaskEndNotification
implements APRequest {
    private AbstractTask task;

    public TaskEndNotification(AbstractTask task) {
        this.task = task;
    }

    public AbstractTask getTask() {
        return this.task;
    }

    public void setTask(AbstractTask task) {
        this.task = task;
    }

    @Override
    public void process(AccessProcessor ap, TaskDispatcher td) {
        long start = System.currentTimeMillis();
        this.task.end(false);
        if (DEBUG) {
            long time = System.currentTimeMillis() - start;
            int taskId = this.task.getId();
            LOGGER.debug("Task " + taskId + " end message processed in " + time + " ms.");
        }
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.UPDATE_GRAPH;
    }
}

