/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.data.BindingDataManager;
import es.bsc.compss.exceptions.AnnounceException;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.invokers.types.CParams;
import es.bsc.compss.invokers.types.JavaParams;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.types.RParams;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.local.LocalJob;
import es.bsc.compss.local.LocalParameter;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.copy.CompletedCopyException;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationExecutionRequest;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.NonExistentDataException;
import es.bsc.compss.types.execution.exceptions.UnloadableValueException;
import es.bsc.compss.types.execution.exceptions.UnwritableValueException;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.FileOpsManager;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.utils.execution.ExecutionManager;
import es.bsc.compss.utils.execution.ThreadedPrintStream;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.distrostreamlib.server.types.StreamBackend;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public final class COMPSsMaster
extends COMPSsWorker
implements InvocationContext {
    private static final String ERROR_TEMP_DIR = "ERROR: Cannot create temp directory";
    private static final String EXECUTION_MANAGER_ERR = "Error starting ExecutionManager";
    public static final String SUFFIX_OUT = ".out";
    public static final String SUFFIX_ERR = ".err";
    private COMPSsRuntime runtimeApi;
    private LoaderAPI loaderApi;
    private final String storageConf;
    private final COMPSsConstants.TaskExecution executionType;
    private final String installDirPath;
    private final String appDirPath;
    private final String tempDirPath;
    private final LanguageParams[] langParams = new LanguageParams[COMPSsConstants.Lang.values().length];
    private boolean persistentEnabled;
    private ExecutionManager executionManager;
    private final ThreadedPrintStream out;
    private final ThreadedPrintStream err;
    private boolean started = false;
    private boolean ear = false;
    private boolean dataProvenance = false;

    public COMPSsMaster(NodeMonitor monitor) {
        super(monitor);
        String earing;
        String pythonCacheProfilerPath;
        File pythonCacheProfilerFile;
        String pythonCacheProfiler;
        String pythonWorkerCache;
        String pythonMpiWorker;
        String pythonExtraeFile;
        String pythonPath;
        String pythonPropagateVEnv;
        String pythonVEnv;
        String pythonVersion;
        String appDir;
        String storageConf;
        LoggerManager.init();
        String wDir = System.getProperty("compss.master.workingDir");
        if (wDir != null && !wDir.isEmpty()) {
            if (!wDir.endsWith(File.separator)) {
                wDir = wDir + File.separator;
            }
            this.tempDirPath = wDir;
        } else {
            this.tempDirPath = LoggerManager.getLogDir() + "tmpFiles" + File.separator;
        }
        boolean wDirExists = new File(this.tempDirPath).exists();
        if (!wDirExists && !new File(this.tempDirPath).mkdirs()) {
            ErrorManager.error(ERROR_TEMP_DIR);
        }
        if ((storageConf = System.getProperty("compss.storage.conf")) == null || storageConf.equals("") || storageConf.equals("null")) {
            storageConf = "null";
            LOGGER.warn("No storage configuration file passed");
        }
        this.storageConf = storageConf;
        String executionType = System.getProperty("compss.task.execution");
        if (executionType == null || executionType.equals("") || executionType.equals("null")) {
            executionType = COMPSsConstants.TaskExecution.COMPSS.toString();
            LOGGER.warn("No executionType passed");
        } else {
            executionType = executionType.toUpperCase();
        }
        this.executionType = COMPSsConstants.TaskExecution.valueOf(executionType);
        this.runtimeApi = null;
        this.loaderApi = null;
        this.out = new ThreadedPrintStream(SUFFIX_OUT, System.out);
        this.err = new ThreadedPrintStream(SUFFIX_ERR, System.err);
        System.setErr(this.err);
        System.setOut(this.out);
        this.installDirPath = System.getenv("COMPSS_HOME");
        String classPath = System.getProperty("compss.worker.cp");
        if (classPath == null || classPath.isEmpty()) {
            classPath = "";
        }
        if ((appDir = System.getProperty("compss.worker.appdir")) == null || appDir.isEmpty()) {
            appDir = "";
        }
        this.appDirPath = appDir;
        String pythonInterpreter = System.getProperty("compss.python.interpreter");
        if (pythonInterpreter == null || pythonInterpreter.isEmpty() || pythonInterpreter.equals("null")) {
            pythonInterpreter = "python3";
        }
        if ((pythonVersion = System.getProperty("compss.python.version")) == null || pythonVersion.isEmpty() || pythonVersion.equals("null")) {
            pythonVersion = "3";
        }
        if ((pythonVEnv = System.getProperty("compss.python.virtualenvironment")) == null || pythonVEnv.isEmpty() || pythonVEnv.equals("null")) {
            pythonVEnv = "null";
        }
        if ((pythonPropagateVEnv = System.getProperty("compss.python.propagate_virtualenvironment")) == null || pythonPropagateVEnv.isEmpty() || pythonPropagateVEnv.equals("null")) {
            pythonPropagateVEnv = "true";
        }
        if ((pythonPath = System.getProperty("compss.worker.pythonpath")) == null || pythonPath.isEmpty()) {
            pythonPath = "";
        }
        if ((pythonExtraeFile = System.getProperty("compss.extrae.file.python")) == null || pythonExtraeFile.isEmpty() || pythonExtraeFile.equals("null")) {
            pythonExtraeFile = "null";
        }
        if ((pythonMpiWorker = System.getProperty("compss.python.mpi_worker")) == null || pythonMpiWorker.isEmpty() || pythonMpiWorker.equals("null")) {
            pythonMpiWorker = "false";
        }
        if ((pythonWorkerCache = System.getProperty("compss.python.worker_cache")) == null || pythonWorkerCache.isEmpty() || pythonWorkerCache.equals("null")) {
            pythonWorkerCache = "false";
        }
        if ((pythonCacheProfiler = System.getProperty("compss.python.cache_profiler")) == null || pythonCacheProfiler.isEmpty() || pythonCacheProfiler.equals("null")) {
            pythonCacheProfiler = "false";
        }
        if (Boolean.parseBoolean(pythonCacheProfiler) && !(pythonCacheProfilerFile = new File(pythonCacheProfilerPath = this.tempDirPath + "cache_profiler.json")).exists()) {
            try {
                FileOutputStream pythonCacheProfilerFOS = new FileOutputStream(pythonCacheProfilerFile);
                String emptyJsonContent = "{}";
                pythonCacheProfilerFOS.write(emptyJsonContent.getBytes());
                pythonCacheProfilerFOS.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((earing = System.getProperty("compss.ear")) == null || earing.isEmpty() || earing.equals("null")) {
            earing = "false";
        }
        this.ear = earing.toUpperCase().compareTo("TRUE") == 0;
        String provenance = System.getProperty("compss.data_provenance");
        if (provenance == null || provenance.isEmpty() || provenance.equals("null")) {
            provenance = "false";
        }
        this.dataProvenance = provenance.toUpperCase().compareTo("TRUE") == 0;
        JavaParams javaParams = new JavaParams(classPath);
        PythonParams pyParams = new PythonParams(pythonInterpreter, pythonVersion, pythonVEnv, pythonPropagateVEnv, pythonPath, pythonExtraeFile, pythonMpiWorker, pythonWorkerCache, pythonCacheProfiler);
        CParams cParams = new CParams(classPath);
        this.langParams[COMPSsConstants.Lang.JAVA.ordinal()] = javaParams;
        this.langParams[COMPSsConstants.Lang.PYTHON.ordinal()] = pyParams;
        this.langParams[COMPSsConstants.Lang.C.ordinal()] = cParams;
        RParams rParams = new RParams(classPath);
        this.langParams[COMPSsConstants.Lang.R.ordinal()] = rParams;
        String workerPersistentC = System.getProperty("compss.worker.persistent.c");
        if (workerPersistentC == null || workerPersistentC.isEmpty() || workerPersistentC.equals("null")) {
            workerPersistentC = "false";
        }
        this.persistentEnabled = workerPersistentC.toUpperCase().compareTo("TRUE") == 0;
        boolean reuse = Boolean.parseBoolean(System.getProperty("compss.execution.reuseOnBlock"));
        this.executionManager = new ExecutionManager(this, 0, "disabled", reuse, 0, "disabled", 0, "disabled", 0, 0);
        try {
            this.executionManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(EXECUTION_MANAGER_ERR, ie);
        }
    }

    @Override
    public String getName() {
        return MASTER_NAME;
    }

    @Override
    public String getAdaptor() {
        return null;
    }

    @Override
    public Object getProjectProperties() {
        return null;
    }

    @Override
    public Object getResourcesProperties() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        COMPSsMaster cOMPSsMaster = this;
        synchronized (cOMPSsMaster) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
    }

    @Override
    public void setInternalURI(MultiURI u) {
        for (CommAdaptor adaptor : Comm.getAdaptors().values()) {
            adaptor.completeMasterURI(u);
        }
    }

    @Override
    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    @Override
    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        for (Resource targetRes : target.getHosts()) {
            COMPSsNode node = targetRes.getNode();
            if (node == this) continue;
            try {
                node.obtainData(ld, source, target, tgtData, reason, listener);
            }
            catch (Exception e) {
                continue;
            }
            return;
        }
    }

    public void obtainBindingData(final LogicalData ld, DataLocation source, final DataLocation target, final LogicalData tgtData, final Transferable reason, final EventListener listener) {
        COMPSsNode node;
        final BindingObject tgtBO = ((BindingObjectLocation)target).getBindingObject();
        Collection<Copy> copiesInProgress = ld.getCopiesInProgress();
        if (copiesInProgress != null && !copiesInProgress.isEmpty()) {
            for (final Copy copy : copiesInProgress) {
                if (copy == null) continue;
                if (copy.getTargetLoc() != null && copy.getTargetLoc().getHosts().contains(Comm.getAppHost())) {
                    if (DEBUG) {
                        LOGGER.debug("Copy in progress tranfering " + ld.getName() + "to master. Waiting for finishing");
                    }
                    copy.addEventListener(new EventListener(){

                        @Override
                        public void notifyEnd(DataOperation fOp) {
                            if (COMPSsNode.DEBUG) {
                                COMPSsNode.LOGGER.debug("Master local copy " + ld.getName() + " from " + copy.getFinalTarget() + " to " + tgtBO.getName());
                            }
                            try {
                                if (COMPSsMaster.this.persistentEnabled) {
                                    COMPSsMaster.this.manageObtainBindingObjectInCache(copy.getFinalTarget(), tgtBO, tgtData, target, reason);
                                } else {
                                    COMPSsMaster.this.manageObtainBindingObjectAsFile(copy.getFinalTarget(), tgtBO, tgtData, target, reason);
                                }
                                listener.notifyEnd(null);
                            }
                            catch (Exception e) {
                                COMPSsNode.LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                                listener.notifyFailure(fOp, e);
                            }
                        }

                        @Override
                        public void notifyFailure(DataOperation fOp, Exception e) {
                            if (COMPSsNode.DEBUG) {
                                COMPSsNode.LOGGER.debug("Master local copy " + ld.getName() + " from " + copy.getFinalTarget() + " to " + tgtBO.getName());
                            }
                            COMPSsNode.LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                            listener.notifyFailure(fOp, e);
                        }
                    });
                    return;
                }
                if (!DEBUG) continue;
                LOGGER.debug("Current copies are not transfering " + ld.getName() + " to master. Ignoring at this moment");
            }
        }
        if (DEBUG) {
            LOGGER.debug("Checking if " + ld.getName() + " is at master (" + Comm.getAppHost().getName() + ").");
        }
        for (MultiURI u : ld.getURIs()) {
            String hostname;
            if (DEBUG) {
                hostname = u.getHost() != null ? u.getHost().getName() : "null";
                LOGGER.debug(ld.getName() + " is at " + u.toString() + "(" + hostname + ")");
            }
            if (u.getHost() == Comm.getAppHost()) {
                if (DEBUG) {
                    LOGGER.debug("Master local copy " + ld.getName() + " from " + u.getHost().getName() + " to " + tgtBO.getName());
                }
                try {
                    if (this.persistentEnabled) {
                        this.manageObtainBindingObjectInCache(u.getPath(), tgtBO, tgtData, target, reason);
                    } else {
                        this.manageObtainBindingObjectAsFile(u.getPath(), tgtBO, tgtData, target, reason);
                    }
                    listener.notifyEnd(null);
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                    listener.notifyFailure(null, e);
                }
                return;
            }
            if (!DEBUG) continue;
            hostname = u.getHost() != null ? u.getHost().getName() : "null";
            LOGGER.debug("Data " + ld.getName() + " copy in " + hostname + " not evaluated now");
        }
        if (source != null) {
            for (Resource sourceRes : source.getHosts()) {
                node = sourceRes.getNode();
                String sourcePath = source.getURIInHost(sourceRes).getPath();
                if (node != this) {
                    try {
                        if (DEBUG) {
                            LOGGER.debug("Sending data " + ld.getName() + " from (" + node.getName() + ") " + sourcePath + " to (master) " + tgtBO.getName());
                        }
                        node.sendData(ld, source, target, tgtData, reason, listener);
                    }
                    catch (Exception e) {
                        ErrorManager.warn("Not possible to sending data master to " + tgtBO.getName(), e);
                        continue;
                    }
                    LOGGER.debug("Data " + ld.getName() + " sent.");
                    return;
                }
                try {
                    if (this.persistentEnabled) {
                        this.manageObtainBindingObjectInCache(sourcePath, tgtBO, tgtData, target, reason);
                    } else {
                        this.manageObtainBindingObjectAsFile(sourcePath, tgtBO, tgtData, target, reason);
                    }
                    listener.notifyEnd(null);
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                    listener.notifyFailure(null, e);
                }
                return;
            }
        } else {
            LOGGER.debug("Source data location is null. Trying other alternatives");
        }
        for (Resource sourceRes : ld.getAllHosts()) {
            node = sourceRes.getNode();
            if (node != this) {
                try {
                    LOGGER.debug("Sending data " + ld.getName() + " from (" + node.getName() + ") " + sourceRes.getName() + " to (master)" + tgtBO.getName());
                    node.sendData(ld, source, target, tgtData, reason, listener);
                }
                catch (Exception e) {
                    LOGGER.error("Error: exception sending data", (Throwable)e);
                    continue;
                }
                LOGGER.debug("Data " + ld.getName() + " sent.");
                return;
            }
            if (!DEBUG) continue;
            LOGGER.debug("Data " + ld.getName() + " copy in " + sourceRes.getName() + " not evaluated now. Should have been evaluated before");
        }
        LOGGER.warn("WARN: All posibilities checked for obtaining data " + ld.getName() + " and nothing done. Releasing listeners and locks");
        listener.notifyEnd(null);
    }

    private void manageObtainBindingObjectInCache(String initialPath, BindingObject tgtBO, LogicalData tgtData, DataLocation target, Transferable reason) throws Exception {
        BindingObject bo = BindingObject.generate(initialPath);
        if (bo.getName().equals(tgtBO.getName())) {
            if (BindingDataManager.isInBinding(tgtBO.getName())) {
                LOGGER.debug("Current transfer is the same as expected. Nothing to do setting data target to " + initialPath);
                reason.setDataTarget(initialPath);
            } else {
                String tgtPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                LOGGER.debug("Data " + tgtBO.getName() + " not in cache loading from file " + tgtPath);
                if (BindingDataManager.loadFromFile(tgtBO.getName(), tgtPath, tgtBO.getType(), tgtBO.getElements()) != 0) {
                    throw new Exception("Error loading object " + tgtBO.getName() + " from " + tgtPath);
                }
                reason.setDataTarget(target.getPath());
            }
        } else {
            if (BindingDataManager.isInBinding(tgtBO.getName())) {
                LOGGER.debug("Making cache copy from " + bo.getName() + " to " + tgtBO.getName());
                if (reason.isSourcePreserved()) {
                    if (BindingDataManager.copyCachedData(bo.getName(), tgtBO.getName()) != 0) {
                        throw new Exception("Error copying cache from " + bo.getName() + " to " + tgtBO.getName());
                    }
                } else if (BindingDataManager.moveCachedData(bo.getName(), tgtBO.getName()) != 0) {
                    throw new Exception("Error moved cache from " + bo.getName() + " to " + tgtBO.getName());
                }
            } else {
                String tgtPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                LOGGER.debug("Data " + tgtBO.getName() + " not in cache loading from file " + tgtPath);
                if (BindingDataManager.loadFromFile(tgtBO.getName(), tgtPath, tgtBO.getType(), tgtBO.getElements()) != 0) {
                    throw new Exception("Error loading object " + tgtBO.getName() + " from " + tgtPath);
                }
            }
            if (tgtData != null) {
                tgtData.addLocation(target);
            }
            LOGGER.debug("BindingObject copied/moved set data target as " + target.getPath());
            reason.setDataTarget(target.getPath());
        }
    }

    private void manageObtainBindingObjectAsFile(String initialPath, BindingObject tgtBO, LogicalData tgtData, DataLocation target, Transferable reason) throws Exception {
        BindingObject bo = BindingObject.generate(initialPath);
        if (bo.getName().equals(tgtBO.getName())) {
            LOGGER.debug("Current transfer is the same as expected. Nothing to do setting data target to " + initialPath);
            reason.setDataTarget(initialPath);
        } else {
            if (bo.getId().startsWith(File.separator)) {
                String iPath = this.getCompletePath(DataType.BINDING_OBJECT_T, bo.getName()).getPath();
                String tPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                if (reason.isSourcePreserved()) {
                    if (DEBUG) {
                        LOGGER.debug("Master local copy of data" + bo.getName() + " from " + iPath + " to " + tPath);
                    }
                    Files.copy(new File(iPath).toPath(), new File(tPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    if (DEBUG) {
                        LOGGER.debug("Master local move of data " + bo.getName() + " from " + iPath + " to " + tPath);
                    }
                    Files.move(new File(iPath).toPath(), new File(tPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            } else if (BindingDataManager.isInBinding(bo.getName())) {
                String tPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                LOGGER.debug("Storing object data " + bo.getName() + " from cache to " + tPath);
                BindingDataManager.storeInFile(bo.getName(), tPath);
            } else {
                throw new Exception("Data " + bo.getName() + "not a filepath and its not in cache");
            }
            if (tgtData != null) {
                tgtData.addLocation(target);
            }
            LOGGER.debug("BindingObject as file copied/moved set data target as " + target.getPath());
            reason.setDataTarget(target.getPath());
        }
        LOGGER.debug(" Checking if BindingObject " + tgtBO.getId() + " has relative path");
        if (!tgtBO.getId().startsWith(File.separator)) {
            LOGGER.debug("Loading BindingObject " + tgtBO.getName() + " to cache...");
            String tgtPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
            if (BindingDataManager.loadFromFile(tgtBO.getName(), tgtPath, tgtBO.getType(), tgtBO.getElements()) != 0) {
                throw new Exception("Error loading object " + tgtBO.getName() + " from " + tgtPath);
            }
        }
    }

    private void handleInMemoryCopy(final LogicalData ld, final DataLocation src, final LogicalData tgtData, final DataLocation tgtLoc, final String tgtPath, final Transferable reason, final EventListener listener) {
        if (ld.isAlias(tgtData)) {
            LOGGER.debug("Object already in memory. Avoiding copy and setting dataTarget to " + tgtPath);
            this.notifyDataObtaining(tgtPath, reason, listener);
        } else {
            final SimpleURI serialURI = this.getCompletePath(DataType.FILE_T, tgtPath);
            String serialPath = serialURI.getPath();
            LOGGER.debug("Serializing data " + ld.getName() + " to " + serialPath);
            Object o = ld.getValue();
            FileOpsManager.serializeAsync(o, serialPath, new FileOpsManager.FileOpListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed() {
                    if (tgtData != null) {
                        try {
                            DataLocation loc = DataLocation.createLocation(Comm.getAppHost(), serialURI);
                            LogicalData logicalData = tgtData;
                            synchronized (logicalData) {
                                tgtData.addLocation(loc);
                            }
                            COMPSsNode.LOGGER.debug("Object in memory. Set dataTarget to " + tgtPath);
                            COMPSsMaster.this.notifyDataObtaining(tgtPath, reason, listener);
                        }
                        catch (IOException ioe) {
                            this.failed(ioe);
                        }
                    }
                }

                @Override
                public void failed(IOException e) {
                    ErrorManager.warn("Error copying file from memory to " + tgtPath, e);
                    COMPSsMaster.this.obtainDataAsynch(ld, src, tgtData, tgtLoc, tgtPath, reason, listener);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obtainFileData(LogicalData srcData, DataLocation srcLoc, LogicalData tgtData, DataLocation tgtLoc, String tgtPath, Transferable reason, EventListener listener) {
        Set<Resource> set;
        Collection<Copy> copiesInProgress;
        List<MultiURI> uris = srcData.getURIs();
        for (MultiURI multiURI : uris) {
            if (DEBUG) {
                String hostname = multiURI.getHost() != null ? multiURI.getHost().getName() : "null";
                LOGGER.debug(srcData.getName() + " is at " + multiURI.toString() + "(" + hostname + ")");
            }
            if (multiURI.getHost().getNode() != this) continue;
            String localPath = multiURI.getPath();
            if ((!reason.isTargetFlexible() || !srcData.isAlias(tgtData)) && tgtPath.compareTo(localPath) != 0) continue;
            LOGGER.debug(srcData.getName() + " is already at " + localPath);
            this.notifyDataObtaining(multiURI.getPath(), reason, listener);
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Data " + srcData.getName() + " not in memory. Checking if there is a copy to the master in progress");
        }
        if ((copiesInProgress = srcData.getCopiesInProgress()) != null && !copiesInProgress.isEmpty() && this.handleSiblingCopy(srcData, tgtData, tgtLoc, tgtPath, reason, listener, copiesInProgress)) {
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Checking if " + srcData.getName() + " is at master (" + Comm.getAppHost().getName() + ").");
        }
        for (MultiURI u : uris) {
            String hostname;
            if (DEBUG) {
                hostname = u.getHost() != null ? u.getHost().getName() : "null";
                LOGGER.debug(srcData.getName() + " is at " + u.toString() + "(" + hostname + ")");
            }
            if (u.getHost().getNode() == this) {
                if (!this.handleLocalFileCopy(srcData, u, tgtData, tgtLoc, tgtPath, reason, listener)) continue;
                return;
            }
            if (!DEBUG) continue;
            hostname = u.getHost() != null ? u.getHost().getName() : "null";
            LOGGER.debug("Data " + srcData.getName() + " copy in " + hostname + " not evaluated now");
        }
        if (srcLoc != null) {
            if (this.handleTransferFromSpecificRemoteLocation(srcData, srcLoc, tgtData, tgtLoc, reason, listener)) {
                return;
            }
        } else {
            LOGGER.debug("Source data location is null. Trying other alternatives");
        }
        LogicalData logicalData = srcData;
        synchronized (logicalData) {
            set = srcData.getAllHosts();
        }
        if (this.handleTransferFromRemote(srcData, set, srcLoc, tgtData, tgtLoc, reason, listener)) {
            return;
        }
        ErrorManager.warn("Error file " + srcData.getName() + " not transferred to " + tgtPath);
        listener.notifyFailure(null, null);
    }

    private boolean handleSiblingCopy(LogicalData ld, LogicalData tgtData, DataLocation tgtLoc, String tgtPath, Transferable reason, EventListener listener, Collection<Copy> copiesInProgress) {
        for (Copy copy : copiesInProgress) {
            DataLocation copyLoc;
            if (copy == null || (copyLoc = copy.getTargetLoc()) == null || !copyLoc.getHosts().contains(Comm.getAppHost())) continue;
            try {
                if (tgtLoc.getProtocol() == ProtocolType.OBJECT_URI && ld.isAlias(tgtData)) {
                    reason.setDataTarget(tgtPath);
                    copy.addEventListener(listener);
                } else {
                    copy.addSiblingCopy(tgtPath, tgtLoc, tgtData, reason, listener);
                }
                LOGGER.debug("Copy in progress tranferring " + ld.getName() + " to master. Wait for finish");
                return true;
            }
            catch (CompletedCopyException completedCopyException) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleLocalFileCopy(LogicalData ld, MultiURI localURI, LogicalData tgtData, DataLocation tgtLoc, String tgtPath, Transferable reason, EventListener listener) {
        String localPath = localURI.getPath();
        try {
            boolean inMemory;
            block21: {
                if (DEBUG) {
                    LOGGER.debug("Data " + ld.getName() + " is already accessible at " + localPath);
                }
                inMemory = false;
                if (tgtLoc.getProtocol() == ProtocolType.OBJECT_URI) {
                    try {
                        if (DEBUG) {
                            LOGGER.debug("Deserializing from file " + localPath);
                        }
                        Object o = FileOpsManager.deserializeSync(localPath);
                        tgtData.setValue(o);
                        inMemory = true;
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block21;
                        LOGGER.debug("Could not deserialize from file " + localPath);
                    }
                }
            }
            if (!inMemory) {
                DataType type = tgtLoc.getProtocol() == ProtocolType.DIR_URI ? DataType.DIRECTORY_T : DataType.FILE_T;
                SimpleURI serialURI = this.getCompletePath(type, tgtPath);
                tgtLoc = DataLocation.createLocation(Comm.getAppHost(), serialURI);
                if (reason.isSourcePreserved() || ld.countKnownAlias() > 1) {
                    if (DEBUG) {
                        LOGGER.debug("Master local copy " + ld.getName() + " from " + localURI.getHost().getName() + " to " + tgtPath);
                    }
                    FileOpsManager.copySync(new File(localPath), new File(tgtPath));
                } else {
                    if (DEBUG) {
                        LOGGER.debug("Master local move " + ld.getName() + " from " + localURI.getHost().getName() + " to " + tgtPath);
                    }
                    try {
                        SimpleURI deletedUri = new SimpleURI(localPath);
                        DataLocation loc = DataLocation.createLocation(Comm.getAppHost(), deletedUri);
                        LogicalData logicalData = ld;
                        synchronized (logicalData) {
                            ld.removeLocation(loc);
                        }
                    }
                    catch (Exception e) {
                        ErrorManager.error("ERROR: Invalid location URI " + tgtPath, e);
                    }
                    FileOpsManager.moveSync(new File(localPath), new File(tgtPath));
                }
            }
            if (tgtData != null) {
                LogicalData logicalData = tgtData;
                synchronized (logicalData) {
                    tgtData.addLocation(tgtLoc);
                }
            }
            LOGGER.debug("File on path. Set data target to " + tgtPath);
            this.notifyDataObtaining(tgtPath, reason, listener);
            return true;
        }
        catch (IOException ex) {
            ErrorManager.warn("Error master local copy file from " + localURI.getPath() + " to " + tgtPath + " with replacing", ex);
            return false;
        }
    }

    private boolean handleTransferFromSpecificRemoteLocation(LogicalData ld, DataLocation srcLoc, LogicalData tgtData, DataLocation tgtLoc, Transferable reason, EventListener listener) {
        for (Resource srcRes : srcLoc.getHosts()) {
            if (!this.handleTransferFromSpecificRemote(ld, srcRes, srcLoc, tgtData, tgtLoc, reason, listener)) continue;
            return true;
        }
        return false;
    }

    private boolean handleTransferFromRemote(LogicalData ld, Set<Resource> hosts, DataLocation srcLoc, LogicalData tgtData, DataLocation tgtLoc, Transferable reason, EventListener listener) {
        for (Resource srcRes : hosts) {
            if (!this.handleTransferFromSpecificRemote(ld, srcRes, srcLoc, tgtData, tgtLoc, reason, listener)) continue;
            return true;
        }
        return false;
    }

    private boolean handleTransferFromSpecificRemote(LogicalData ld, Resource srcRes, DataLocation srcLoc, LogicalData tgtData, DataLocation tgtLoc, Transferable reason, EventListener listener) {
        COMPSsNode node = srcRes.getNode();
        if (node != this) {
            try {
                LOGGER.debug("Sending data " + ld.getName() + " from " + srcRes.getName() + " to " + tgtLoc);
                node.sendData(ld, srcLoc, tgtLoc, tgtData, reason, listener);
                LOGGER.debug("Data " + ld.getName() + " sent.");
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Error: exception sending data", (Throwable)e);
            }
        } else if (DEBUG) {
            LOGGER.debug("Data " + ld.getName() + " copy in " + srcRes.getName() + " already checked");
        }
        return false;
    }

    private void notifyDataObtaining(String path, Transferable reason, EventListener listener) {
        reason.setDataTarget(path);
        listener.notifyEnd(null);
    }

    @Override
    public void obtainData(LogicalData srcData, DataLocation srcLoc, DataLocation tgtLoc, LogicalData tgtData, Transferable reason, EventListener listener) {
        LOGGER.info("Obtain Data " + srcData.getName());
        if (DEBUG) {
            LOGGER.debug(srcData != null ? "srcData: " + srcData.toString() : "srcData is null");
            LOGGER.debug(reason != null ? "Reason: " + (Object)((Object)reason.getType()) : "Reason is null");
            LOGGER.debug(srcLoc != null ? "Source Data location: " + srcLoc.getType().toString() + " " + srcLoc.getProtocol().toString() + " " + srcLoc.getURIs().get(0) : "Source Data location is null");
            if (tgtLoc != null) {
                if (tgtLoc.getProtocol() != ProtocolType.PERSISTENT_URI) {
                    LOGGER.debug("Target Data location: " + tgtLoc.getType().toString() + " " + tgtLoc.getProtocol().toString() + " " + tgtLoc.getURIs().get(0));
                } else {
                    LOGGER.debug("Target Data location: " + tgtLoc.getType().toString() + " " + tgtLoc.getProtocol().toString());
                }
            } else {
                LOGGER.debug("Target Data location is null");
            }
            LOGGER.debug(tgtData != null ? "tgtData: " + tgtData.toString() : "tgtData is null");
        }
        String tgtPath = null;
        if (tgtLoc != null) {
            tgtPath = tgtLoc.getURIInHost(Comm.getAppHost()).getPath();
        }
        if (reason != null && (reason.getType().equals((Object)DataType.COLLECTION_T) || reason.getType().equals((Object)DataType.DICT_COLLECTION_T))) {
            this.obtainCollection(srcData, srcLoc, tgtData, tgtLoc, tgtPath, reason, listener);
            return;
        }
        if (srcData.isBindingData() || reason != null && reason.getType().equals((Object)DataType.BINDING_OBJECT_T) || srcLoc != null && srcLoc.getType().equals((Object)LocationType.BINDING) || tgtLoc != null && tgtLoc.getType().equals((Object)LocationType.BINDING)) {
            this.obtainBindingData(srcData, srcLoc, tgtLoc, tgtData, reason, listener);
            return;
        }
        String pscoId = srcData.getPscoId();
        if (pscoId != null) {
            this.obtainPSCO(pscoId, reason, listener);
            return;
        }
        if (srcData.isInMemory() && srcData.isAlias(tgtData)) {
            LOGGER.debug("Object already in memory. Avoiding copy and setting dataTarget to " + tgtPath);
            this.notifyDataObtaining(tgtPath, reason, listener);
            return;
        }
        this.obtainDataAsynch(srcData, srcLoc, tgtData, tgtLoc, tgtPath, reason, listener);
    }

    private void obtainCollection(LogicalData srcData, DataLocation srcLoc, LogicalData tgtData, DataLocation target, String tgtPath, Transferable reason, EventListener listener) {
        String targetPath;
        if (target != null) {
            targetPath = target.getURIInHost(Comm.getAppHost()).getPath();
        } else if (tgtData != null) {
            targetPath = tgtData.getName();
        } else {
            targetPath = srcData.getName();
            LOGGER.warn("No target location neither target data available. Setting targetPath to " + srcData.getName());
        }
        LOGGER.debug("Data " + srcData.getName() + "is COLLECTION_T/DICT_COLLECTION_T nothing to tranfer. Elements already transferred.Setting target path to " + targetPath);
        this.notifyDataObtaining(tgtPath, reason, listener);
    }

    private void obtainPSCO(String pscoId, Transferable reason, EventListener listener) {
        LOGGER.debug("Object in Persistent Storage. Set dataTarget to " + pscoId);
        this.notifyDataObtaining(pscoId, reason, listener);
    }

    private void obtainDataAsynch(final LogicalData srcData, final DataLocation srcLoc, final LogicalData tgtData, final DataLocation tgtLoc, final String tgtPath, final Transferable reason, final EventListener listener) {
        FileOpsManager.composedOperationAsync(new Runnable(){

            @Override
            public void run() {
                if (srcData.isInMemory()) {
                    COMPSsMaster.this.handleInMemoryCopy(srcData, srcLoc, tgtData, tgtLoc, tgtPath, reason, listener);
                    return;
                }
                COMPSsMaster.this.obtainFileData(srcData, srcLoc, tgtData, tgtLoc, tgtPath, reason, listener);
            }
        });
    }

    @Override
    public void enforceDataObtaining(Transferable reason, EventListener listener) {
        listener.notifyEnd(null);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return new LocalJob(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    @Override
    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case DIRECTORY_T: {
                if (!name.startsWith(File.separator)) {
                    name = this.tempDirPath + name;
                }
                path = ProtocolType.DIR_URI.getSchema() + name;
                break;
            }
            case FILE_T: {
                if (!name.startsWith(File.separator)) {
                    name = this.tempDirPath + name;
                }
                path = ProtocolType.FILE_URI.getSchema() + name;
                break;
            }
            case OBJECT_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + name;
                break;
            }
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + this.tempDirPath + name;
                break;
            }
            case STREAM_T: {
                path = ProtocolType.STREAM_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_STREAM_T: {
                path = ProtocolType.EXTERNAL_STREAM_URI.getSchema() + this.tempDirPath + name;
                break;
            }
            case PSCO_T: 
            case EXTERNAL_PSCO_T: {
                path = ProtocolType.PERSISTENT_URI.getSchema() + name;
                break;
            }
            case BINDING_OBJECT_T: {
                path = ProtocolType.BINDING_URI.getSchema() + this.tempDirPath + name;
                break;
            }
            default: {
                LOGGER.warn("Unrecognized type: " + (Object)((Object)type));
                return null;
            }
        }
        return new SimpleURI(path);
    }

    @Override
    public void deleteTemporary() {
        File dir = new File(Comm.getAppHost().getWorkingDirectory());
        for (File f : dir.listFiles()) {
            this.deleteFolder(f);
        }
    }

    private void deleteFolder(File folder) {
        if (folder.isDirectory()) {
            for (File f : folder.listFiles()) {
                this.deleteFolder(f);
            }
        }
        if (!folder.delete()) {
            LOGGER.error("Error deleting file " + (folder == null ? "" : folder.getName()));
        }
    }

    @Override
    public Set<String> generateWorkerAnalysisFiles() {
        return null;
    }

    @Override
    public Set<String> generateWorkerDebugFiles() {
        return null;
    }

    @Override
    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        this.executionManager.stop();
        sl.notifyEnd();
    }

    @Override
    public String getUser() {
        return "";
    }

    @Override
    public String getClasspath() {
        return "";
    }

    @Override
    public String getPythonpath() {
        return "";
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void announceDestruction() throws AnnounceException {
    }

    @Override
    public void announceCreation() throws AnnounceException {
    }

    public void runJob(final LocalJob job) {
        InvocationExecutionRequest.Listener listener = new InvocationExecutionRequest.Listener(){

            @Override
            public void onResultAvailable(InvocationParam param) {
                LocalParameter lp = (LocalParameter)param;
                job.notifyResultAvailable(lp);
            }

            @Override
            public void notifyEnd(Invocation invocation, boolean success, COMPSsException e) {
                job.profileEndNotification();
                if (success) {
                    job.completed();
                } else if (e != null) {
                    job.exception(e);
                } else {
                    job.failed(JobEndStatus.EXECUTION_FAILED);
                }
            }
        };
        InvocationExecutionRequest exec = new InvocationExecutionRequest(job, listener);
        this.executionManager.enqueue(exec);
    }

    @Override
    public String getHostName() {
        return MASTER_NAME;
    }

    @Override
    public long getTracingHostID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getAppDir() {
        return this.appDirPath;
    }

    @Override
    public String getInstallDir() {
        return this.installDirPath;
    }

    @Override
    public String getWorkingDir() {
        return this.tempDirPath;
    }

    @Override
    public String getLogDir() {
        return LoggerManager.getLogDir();
    }

    @Override
    public String getAnalysisDir() {
        return this.tempDirPath + "analysis/";
    }

    @Override
    public COMPSsConstants.TaskExecution getExecutionType() {
        return this.executionType;
    }

    @Override
    public boolean isPersistentCEnabled() {
        return this.persistentEnabled;
    }

    @Override
    public LanguageParams getLanguageParams(COMPSsConstants.Lang language) {
        return this.langParams[language.ordinal()];
    }

    @Override
    public void registerOutputs(String path) {
        this.err.registerThread(path);
        this.out.registerThread(path);
    }

    @Override
    public void unregisterOutputs() {
        this.err.unregisterThread();
        this.out.unregisterThread();
    }

    @Override
    public String getStandardStreamsPath(Invocation invocation) {
        return LoggerManager.getJobsLogDir() + "job" + invocation.getJobId() + "_" + (Object)((Object)invocation.getHistory());
    }

    @Override
    public PrintStream getThreadOutStream() {
        return this.out.getStream();
    }

    @Override
    public PrintStream getThreadErrStream() {
        return this.err.getStream();
    }

    @Override
    public String getStorageConf() {
        return this.storageConf;
    }

    @Override
    public StreamBackend getStreamingBackend() {
        return Comm.getStreamingBackend();
    }

    @Override
    public String getStreamingMasterName() {
        return MASTER_NAME;
    }

    @Override
    public int getStreamingMasterPort() {
        return Comm.getStreamingPort();
    }

    @Override
    public void loadParam(InvocationParam invParam) throws UnloadableValueException {
        LocalParameter localParam = (LocalParameter)invParam;
        switch (localParam.getType()) {
            case FILE_T: {
                break;
            }
            case OBJECT_T: 
            case STREAM_T: {
                DependencyParameter dpar = (DependencyParameter)localParam.getParam();
                String dataId = localParam.getSourceDataId();
                LogicalData ld = Comm.getData(dataId);
                Object value = null;
                if (ld.isInMemory()) {
                    value = ld.getValue();
                } else {
                    try {
                        ld.loadFromStorage();
                        value = ld.getValue();
                    }
                    catch (CannotLoadException cle) {
                        try {
                            value = FileOpsManager.deserializeSync(dpar.getDataTarget());
                        }
                        catch (IOException | ClassNotFoundException e) {
                            throw new UnloadableValueException(e);
                        }
                    }
                }
                invParam.setValue(value);
                break;
            }
            case PSCO_T: {
                String pscoId = (String)localParam.getValue();
                try {
                    Object o = StorageItf.getByID(pscoId);
                    invParam.setValue(o);
                    break;
                }
                catch (StorageException se) {
                    throw new UnloadableValueException(se);
                }
            }
        }
    }

    @Override
    public void storeParam(InvocationParam invParam, boolean createIfNonExistent) throws UnwritableValueException, NonExistentDataException {
        LocalParameter lp = (LocalParameter)invParam;
        Parameter param = lp.getParam();
        SimpleURI resultUri = null;
        switch (param.getType()) {
            case DIRECTORY_T: {
                DataLocation outLoc;
                resultUri = new SimpleURI(ProtocolType.DIR_URI.getSchema() + this.tempDirPath + lp.getDataMgmtId());
                try {
                    outLoc = DataLocation.createLocation(Comm.getAppHost(), resultUri);
                    Comm.registerLocation(lp.getDataMgmtId(), outLoc);
                }
                catch (IOException e) {
                    ErrorManager.error("ERROR: Invalid location URI " + resultUri, e);
                }
                break;
            }
            case FILE_T: {
                resultUri = this.storeFileParam(lp, createIfNonExistent);
                break;
            }
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                DataLocation outLoc;
                resultUri = new SimpleURI(ProtocolType.OBJECT_URI.getSchema() + this.tempDirPath + lp.getDataMgmtId());
                try {
                    outLoc = DataLocation.createLocation(Comm.getAppHost(), resultUri);
                    Comm.registerLocation(lp.getDataMgmtId(), outLoc);
                }
                catch (IOException e) {
                    ErrorManager.error("ERROR: Invalid location URI " + resultUri, e);
                }
                break;
            }
            case OBJECT_T: {
                String resultName = lp.getDataMgmtId();
                Comm.registerValue(resultName, lp.getValue());
                resultUri = new SimpleURI(ProtocolType.OBJECT_URI.getSchema() + resultName);
                break;
            }
            case STREAM_T: {
                String resultName = lp.getDataMgmtId();
                Comm.registerValue(resultName, lp.getValue());
                resultUri = new SimpleURI(ProtocolType.STREAM_URI.getSchema() + resultName);
                break;
            }
            case EXTERNAL_STREAM_T: {
                String resultName = lp.getDataMgmtId();
                resultUri = new SimpleURI(ProtocolType.EXTERNAL_STREAM_URI.getSchema() + this.tempDirPath + resultName);
                try {
                    DataLocation outLoc = DataLocation.createLocation(Comm.getAppHost(), resultUri);
                    Comm.registerLocation(lp.getDataMgmtId(), outLoc);
                }
                catch (IOException e) {
                    ErrorManager.error("ERROR: Invalid location URI " + resultUri, e);
                }
                break;
            }
            case PSCO_T: {
                String pscoId = ((StubItf)lp.getValue()).getID();
                String resultName = lp.getDataMgmtId();
                Comm.registerPSCO(resultName, pscoId);
                resultUri = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + pscoId);
                break;
            }
            case EXTERNAL_PSCO_T: {
                String pscoId = (String)lp.getValue();
                String resultName = lp.getDataMgmtId();
                Comm.registerExternalPSCO(resultName, pscoId);
                resultUri = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + pscoId);
                break;
            }
            case BINDING_OBJECT_T: {
                DataLocation outLoc;
                resultUri = new SimpleURI(ProtocolType.BINDING_URI.getSchema() + this.tempDirPath + lp.getValue());
                try {
                    outLoc = DataLocation.createLocation(Comm.getAppHost(), resultUri);
                    Comm.registerLocation(lp.getDataMgmtId(), outLoc);
                }
                catch (IOException e) {
                    ErrorManager.error("ERROR: Invalid location URI " + resultUri, e);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet." + (Object)((Object)param.getType()));
            }
        }
        DependencyParameter dp = (DependencyParameter)lp.getParam();
        dp.setDataTarget(resultUri.toString());
    }

    private SimpleURI storeFileParam(LocalParameter lp, boolean createIfNonExistent) throws UnwritableValueException, NonExistentDataException {
        String filepath = (String)lp.getValue();
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.CHECK_OUT_PARAM);
        }
        SimpleURI uri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + filepath);
        File f = new File(filepath);
        boolean fExists = f.exists();
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd(TraceEvent.CHECK_OUT_PARAM);
        }
        if (!fExists) {
            if (createIfNonExistent) {
                System.out.println("Creating new blank file at " + filepath);
                try {
                    f.createNewFile();
                    try {
                        DataLocation outLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
                        Comm.registerLocation(lp.getDataMgmtId(), outLoc);
                    }
                    catch (IOException e) {
                        ErrorManager.error("ERROR: Invalid location URI " + filepath, e);
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("ERROR creating new blank file at " + filepath);
                    throw new UnwritableValueException(e);
                }
            }
            throw new NonExistentDataException(filepath);
        }
        try {
            DataLocation outLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
            Comm.registerLocation(lp.getDataMgmtId(), outLoc);
        }
        catch (IOException e) {
            ErrorManager.error("ERROR: Invalid location URI " + filepath, e);
        }
        return uri;
    }

    public String getWorkingDirectory() {
        return this.tempDirPath;
    }

    @Override
    public void increaseComputingCapabilities(ResourceDescription descr) {
        MethodResourceDescription description = (MethodResourceDescription)descr;
        int cpuCount = description.getTotalCPUComputingUnits();
        int gpuCount = description.getTotalGPUComputingUnits();
        int fpgaCount = description.getTotalFPGAComputingUnits();
        int otherCount = description.getTotalOTHERComputingUnits();
        this.executionManager.increaseCapabilities(cpuCount, gpuCount, fpgaCount, otherCount);
    }

    @Override
    public void reduceComputingCapabilities(ResourceDescription descr) {
        MethodResourceDescription description = (MethodResourceDescription)descr;
        int cpuCount = description.getTotalCPUComputingUnits();
        int gpuCount = description.getTotalGPUComputingUnits();
        int fpgaCount = description.getTotalFPGAComputingUnits();
        int otherCount = description.getTotalOTHERComputingUnits();
        this.executionManager.reduceCapabilities(cpuCount, gpuCount, fpgaCount, otherCount);
    }

    @Override
    public void removeObsoletes(List<MultiURI> obsoletes) {
    }

    @Override
    public void verifyNodeIsRunning() {
    }

    @Override
    public COMPSsRuntime getRuntimeAPI() {
        return this.runtimeApi;
    }

    public void setRuntimeApi(COMPSsRuntime runtimeApi) {
        this.runtimeApi = runtimeApi;
    }

    @Override
    public LoaderAPI getLoaderAPI() {
        return this.loaderApi;
    }

    @Override
    public String getEnvironmentScript() {
        return null;
    }

    @Override
    public boolean getEar() {
        return this.ear;
    }

    @Override
    public boolean getDataProvenance() {
        return this.dataProvenance;
    }

    public void setLoaderApi(LoaderAPI loaderApi) {
        this.loaderApi = loaderApi;
    }
}

