/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessid;

import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.DataVersion;

public class RAccessId
extends EngineDataAccessId
implements EngineDataAccessId.ReadingDataAccessId {
    private static final long serialVersionUID = 1L;
    private DataVersion readDataVersion;

    public RAccessId() {
    }

    public RAccessId(DataInfo data, DataVersion rdv) {
        super(data);
        this.readDataVersion = rdv;
    }

    @Override
    public DataAccessId.Direction getDirection() {
        return DataAccessId.Direction.R;
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.readDataVersion.hasMoreReaders() || this.readDataVersion.getDataInstanceId().getVersionId() == 1;
    }

    @Override
    public boolean isRead() {
        return true;
    }

    @Override
    public DataVersion getReadDataVersion() {
        return this.readDataVersion;
    }

    @Override
    public EngineDataInstanceId getReadDataInstance() {
        return this.readDataVersion.getDataInstanceId();
    }

    @Override
    public int getRVersionId() {
        return this.readDataVersion.getDataInstanceId().getVersionId();
    }

    @Override
    public boolean isWrite() {
        return false;
    }

    public String toString() {
        return "Read data: " + this.readDataVersion.getDataInstanceId() + (this.isPreserveSourceData() ? ", Preserved" : ", Erased");
    }

    @Override
    public EngineDataAccessId consolidateValidVersions() {
        if (!this.readDataVersion.isValid()) {
            DataVersion validR = this.readDataVersion.getPreviousValidPredecessor();
            if (validR != null) {
                return new RAccessId(this.getAccessedDataInfo(), validR);
            }
            return null;
        }
        return this;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"R\",");
        sb.append("\"read_datum\":\"d").append(this.getDataId()).append("v").append(this.getRVersionId()).append("\"");
        sb.append("}");
        return sb.toString();
    }
}

