/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.info;

import es.bsc.compss.types.data.EngineDataInstanceId;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class DataVersion {
    private final EngineDataInstanceId dataInstanceId;
    private int readers;
    private int writers;
    private boolean toDelete;
    private boolean used;
    private boolean semUsed;
    private boolean canceled;
    private boolean valid;
    private List<Semaphore> semReaders;
    private DataVersion prevValidVersion;
    private DataVersion nextValidVersion;
    private boolean valueOnMain;

    public DataVersion(int dataId, int versionId, DataVersion predecessor) {
        this.dataInstanceId = new EngineDataInstanceId(dataId, versionId, this);
        this.valueOnMain = false;
        this.writers = 0;
        this.toDelete = false;
        this.used = false;
        this.canceled = false;
        this.semReaders = new LinkedList<Semaphore>();
        this.semUsed = false;
        this.valid = true;
        this.prevValidVersion = null;
        if (predecessor != null) {
            if (predecessor.isValid()) {
                this.prevValidVersion = predecessor;
                this.prevValidVersion.nextValidVersion = this;
            } else if ((predecessor = predecessor.getPreviousValidPredecessor()) != null) {
                this.prevValidVersion = predecessor;
                this.prevValidVersion.nextValidVersion = this;
            }
        }
    }

    public EngineDataInstanceId getDataInstanceId() {
        return this.dataInstanceId;
    }

    public void willBeRead() {
        ++this.readers;
    }

    public void willBeWritten() {
        ++this.writers;
    }

    public boolean hasPendingLectures() {
        return this.readers > 0;
    }

    public boolean hasMoreReaders() {
        return this.readers > 1;
    }

    public boolean hasBeenRead() {
        --this.readers;
        if (this.readers == 0 && this.semUsed) {
            for (Semaphore s : this.semReaders) {
                s.release();
            }
        }
        return this.toDelete && this.checkDeletion();
    }

    public boolean hasBeenWritten() {
        --this.writers;
        return this.toDelete && this.checkDeletion();
    }

    public boolean markToDelete() {
        this.toDelete = true;
        return this.checkDeletion();
    }

    public void unmarkToDelete() {
        this.toDelete = false;
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    private boolean checkDeletion() {
        if (this.writers == 0 && this.readers == 0) {
            this.invalidate();
            return true;
        }
        return false;
    }

    public void versionUsed() {
        this.used = true;
    }

    public void versionCancelled() {
        this.canceled = true;
        this.invalidate();
    }

    public void invalidate() {
        if (this.valid) {
            this.valid = false;
            if (this.nextValidVersion != null) {
                this.nextValidVersion.prevValidVersion = this.prevValidVersion;
            }
            if (this.prevValidVersion != null) {
                this.prevValidVersion.nextValidVersion = this.nextValidVersion;
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public DataVersion getPreviousValidPredecessor() {
        if (this.prevValidVersion != null && !this.prevValidVersion.isValid()) {
            return this.prevValidVersion.getPreviousValidPredecessor();
        }
        return this.prevValidVersion;
    }

    public boolean hasBeenUsed() {
        return this.used;
    }

    public boolean hasBeenCancelled() {
        return this.canceled;
    }

    public boolean addSemaphore(Semaphore semWait) {
        if (this.readers != 0) {
            this.semUsed = true;
            this.semReaders.add(semWait);
            return true;
        }
        return false;
    }

    public boolean isValueOnMain() {
        return this.valueOnMain;
    }

    public void valueOnMain() {
        this.valueOnMain = true;
    }
}

