/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.List;
import java.util.concurrent.Semaphore;

public class DeleteAllApplicationDataRequest
implements APRequest {
    private final Application app;
    private final Semaphore sem;

    public DeleteAllApplicationDataRequest(Application app) {
        this.app = app;
        this.sem = new Semaphore(0);
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.REMOVE_APP_DATA;
    }

    @Override
    public void process(AccessProcessor ap, TaskDispatcher td) throws ShutdownException {
        List<DataInfo> data = this.app.popAllData();
        for (DataInfo di : data) {
            di.delete();
        }
        this.sem.release();
    }

    public void waitForCompletion() {
        this.sem.acquireUninterruptibly();
    }
}

