/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.access;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.access.MainAccess;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessparams.FileAccessParams;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.data.params.FileData;
import es.bsc.compss.types.uri.SimpleURI;
import java.util.concurrent.Semaphore;

public class FileMainAccess<D extends FileData, P extends FileAccessParams<D>>
extends MainAccess<DataLocation, D, P> {
    public static FileMainAccess<FileData, FileAccessParams<FileData>> constructFMA(Application app, Direction dir, DataLocation loc) {
        FileAccessParams f = FileAccessParams.constructFAP(app, dir, loc);
        return new FileMainAccess<FileData, FileAccessParams<FileData>>(app, f);
    }

    protected FileMainAccess(Application app, P params) {
        super(app, params);
    }

    @Override
    public DataLocation getUnavailableValueResponse() {
        return this.createExpectedLocalLocation("null");
    }

    @Override
    public final DataLocation fetch(EngineDataAccessId daId) {
        EngineDataInstanceId tgtDiId;
        if (daId.isWrite()) {
            EngineDataAccessId.WritingDataAccessId wdaId = (EngineDataAccessId.WritingDataAccessId)((Object)daId);
            tgtDiId = wdaId.getWrittenDataInstance();
        } else {
            EngineDataAccessId.ReadingDataAccessId rdaId = (EngineDataAccessId.ReadingDataAccessId)((Object)daId);
            tgtDiId = rdaId.getReadDataInstance();
        }
        String targetName = tgtDiId.getRenaming();
        String dataDesc = ((FileAccessParams)this.getParameters()).getDataDescription();
        LOGGER_API.debug("Openning file " + targetName);
        DataLocation tgtLocation = ((FileAccessParams)this.getParameters()).getLocation();
        if (daId.isRead()) {
            String pscoId = tgtDiId.getData().getPscoId();
            tgtLocation = pscoId != null ? this.fetchPSCO(pscoId, targetName) : this.fetchData(daId, targetName);
        }
        if (daId.isWrite()) {
            LOGGER_API.debug("Access to " + dataDesc + " mode contains W, register new writer");
            String targetPath = Comm.getAppHost().getWorkingDirectory() + targetName;
            tgtLocation = this.createExpectedLocalLocation(targetPath);
            Comm.registerLocation(targetName, tgtLocation);
        }
        if (API_DEBUG) {
            LOGGER_API.debug(dataDesc + " located on " + (tgtLocation != null ? tgtLocation.toString() : "null"));
        }
        return tgtLocation;
    }

    private DataLocation fetchPSCO(String pscoId, String targetName) {
        LOGGER_API.debug("Auto-release");
        DataLocation targetLocation = this.createPSCOLocation(pscoId);
        Comm.registerLocation(targetName, targetLocation);
        LOGGER_API.debug("Setting target location to " + targetLocation);
        return targetLocation;
    }

    private DataLocation createPSCOLocation(String pscoId) {
        SimpleURI targetURI = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + pscoId);
        return FileMainAccess.createLocalLocation(targetURI);
    }

    protected DataLocation fetchData(EngineDataAccessId daId, String targetName) {
        LogicalData tgtData;
        FileTransferable ft;
        LOGGER_API.debug("Asking for transfer");
        EngineDataAccessId.ReadingDataAccessId rdaId = (EngineDataAccessId.ReadingDataAccessId)((Object)daId);
        LogicalData srcData = rdaId.getReadDataInstance().getData();
        Semaphore sem = new Semaphore(0);
        if (rdaId.isWrite()) {
            ft = this.createExpectedTransferable(daId.isPreserveSourceData());
            tgtData = null;
        } else {
            ft = this.createExpectedTransferable(true);
            tgtData = srcData;
        }
        OneOpWithSemListener listener = new OneOpWithSemListener(sem);
        Comm.getAppHost().getData(srcData, targetName, tgtData, (Transferable)ft, (EventListener)listener);
        sem.acquireUninterruptibly();
        String finalPath = ft.getDataTarget();
        return this.createExpectedLocalLocation(finalPath);
    }

    protected final DataLocation createExpectedLocalLocation(String localPath) {
        SimpleURI targetURI = new SimpleURI(this.expectedProtocol().getSchema() + localPath);
        return FileMainAccess.createLocalLocation(targetURI);
    }

    protected FileTransferable createExpectedTransferable(boolean preserveSource) {
        return new FileTransferable(preserveSource);
    }

    protected ProtocolType expectedProtocol() {
        return ProtocolType.FILE_URI;
    }

    @Override
    public boolean isAccessFinishedOnRegistration() {
        return false;
    }

    @Override
    public boolean resultRemainOnMain() {
        return false;
    }
}

