/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AccessParams<D extends DataParams>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected final Application app;
    protected final D data;
    protected final AccessMode mode;

    private static AccessMode getAccessMode(Direction d) {
        AccessMode am = AccessMode.R;
        switch (d) {
            case IN: 
            case IN_DELETE: {
                am = AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessMode.CV;
            }
        }
        return am;
    }

    protected AccessParams(Application app, D data, Direction dir) {
        this.app = app;
        this.data = data;
        this.mode = AccessParams.getAccessMode(dir);
    }

    public Application getApp() {
        return this.app;
    }

    public D getData() {
        return this.data;
    }

    public final AccessMode getMode() {
        return this.mode;
    }

    public final String getDataDescription() {
        return ((DataParams)this.data).getDescription();
    }

    public abstract void checkAccessValidity() throws ValueUnawareRuntimeException;

    public final EngineDataAccessId register() {
        DataInfo dInfo;
        if (DEBUG) {
            LOGGER.debug("Registering access " + this.getDataDescription());
        }
        if ((dInfo = ((DataParams)this.data).getRegisteredData(this.app)) == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to " + this.getDataDescription());
            }
            dInfo = ((DataParams)this.data).register(this.app);
            if (DEBUG) {
                LOGGER.debug("Registered new data {\"data_id\":" + dInfo.getDataId() + ",\"description\":\"" + this.getDataDescription() + "\"}");
            }
            DataVersion dv = dInfo.getCurrentDataVersion();
            this.registerValueForVersion(dv);
        } else if (DEBUG) {
            LOGGER.debug("Subsequent access to data {\"data_id\":" + dInfo.getDataId() + ",\"description\":\"" + this.getDataDescription() + "\"}");
        }
        this.externalRegister();
        EngineDataAccessId daId = dInfo.willAccess(this.mode);
        if (DEBUG && daId != null) {
            LOGGER.debug("Registered " + daId.toDebugString());
        }
        return daId;
    }

    protected abstract void registerValueForVersion(DataVersion var1);

    protected abstract void externalRegister();

    public final EngineDataAccessId getLastRegisteredAccess() {
        DataInfo dInfo = ((DataParams)this.data).getRegisteredData(this.app);
        if (dInfo == null) {
            LOGGER.warn(this.getDataDescription() + " has not been accessed before");
            return null;
        }
        return dInfo.getLastAccess(this.mode);
    }

    public static enum AccessMode {
        R(true, false),
        W(false, true),
        RW(true, true),
        C(true, false),
        CV(true, true);

        private final boolean read;
        private final boolean write;

        private AccessMode(boolean read, boolean write) {
            this.read = read;
            this.write = write;
        }

        public final boolean isRead() {
            return this.read;
        }

        public boolean isWrite() {
            return this.write;
        }
    }
}

