/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.resources.Resource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SharedDisk {
    private static Map<String, SharedDisk> ALL_DISKS = new TreeMap<String, SharedDisk>();
    private final String name;
    private final List<Resource> resources;
    private final Map<Resource, String> mountpoints;
    private final Set<LogicalData> sharedFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedDisk createDisk(String name) {
        SharedDisk disk;
        Map<String, SharedDisk> map = ALL_DISKS;
        synchronized (map) {
            disk = ALL_DISKS.get(name);
            if (disk == null) {
                disk = new SharedDisk(name);
                ALL_DISKS.put(name, disk);
            }
        }
        return disk;
    }

    private SharedDisk(String name) {
        this.name = name;
        this.resources = new LinkedList<Resource>();
        this.mountpoints = new HashMap<Resource, String>();
        this.sharedFiles = new HashSet<LogicalData>();
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addMountpoint(Resource host, String path) {
        this.resources.add(host);
        this.mountpoints.put(host, path);
    }

    public synchronized String getMountpoint(Resource r) {
        return this.mountpoints.get(r);
    }

    public synchronized String removeMountpoint(Resource r) {
        this.resources.remove(r);
        return this.mountpoints.remove(r);
    }

    public List<Resource> getAllResources() {
        return this.resources;
    }

    public Map<Resource, String> getAllMountpoints() {
        return this.mountpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogicalData(LogicalData ld) {
        Set<LogicalData> set = this.sharedFiles;
        synchronized (set) {
            this.sharedFiles.add(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogicalData(LogicalData obsolete) {
        Set<LogicalData> set = this.sharedFiles;
        synchronized (set) {
            this.sharedFiles.remove(obsolete);
        }
    }

    public Set<LogicalData> getAllSharedFiles() {
        return this.sharedFiles;
    }
}

