/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HTTPResourceDescription
extends WorkerResourceDescription {
    private int connections;
    private List<String> services;

    public HTTPResourceDescription() {
        this.services = new LinkedList<String>();
    }

    public HTTPResourceDescription(List<String> services, int connections) {
        this.services = services;
        this.connections = connections;
    }

    public List<String> getServices() {
        return this.services;
    }

    @Override
    public boolean canHost(Implementation impl) {
        if (!impl.getTaskType().equals((Object)TaskType.HTTP)) {
            return false;
        }
        HTTPResourceDescription hrd = (HTTPResourceDescription)impl.getRequirements();
        return this.services.contains(hrd.getServices().get(0));
    }

    @Override
    public boolean canHostDynamic(Implementation impl) {
        HTTPResourceDescription srd = (HTTPResourceDescription)impl.getRequirements();
        return srd.connections <= this.connections;
    }

    @Override
    public void mimic(ResourceDescription rd) {
    }

    @Override
    public void increase(ResourceDescription rd) {
        HTTPResourceDescription srd = (HTTPResourceDescription)rd;
        this.connections += srd.connections;
    }

    @Override
    public void increaseDynamic(ResourceDescription rd) {
        HTTPResourceDescription srd = (HTTPResourceDescription)rd;
        this.connections += srd.connections;
    }

    @Override
    public void reduce(ResourceDescription rd) {
        HTTPResourceDescription srd = (HTTPResourceDescription)rd;
        this.connections -= srd.connections;
    }

    @Override
    public ResourceDescription reduceDynamic(ResourceDescription rd) {
        HTTPResourceDescription srd = (HTTPResourceDescription)rd;
        this.connections -= srd.connections;
        return new HTTPResourceDescription(srd.services, srd.connections);
    }

    @Override
    public ResourceDescription getDynamicCommons(ResourceDescription constraints) {
        HTTPResourceDescription sConstraints = (HTTPResourceDescription)constraints;
        int conCommons = Math.min(sConstraints.connections, this.connections);
        return new HTTPResourceDescription(sConstraints.services, conCommons);
    }

    @Override
    public boolean isDynamicUseless() {
        return this.connections == 0;
    }

    @Override
    public boolean isDynamicConsuming() {
        return this.connections > 0;
    }

    public String toString() {
        String service;
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"connections\":").append(this.connections).append(",");
        sb.append("\"services\":[");
        Iterator<String> servicesItr = this.services.iterator();
        if (servicesItr.hasNext()) {
            service = servicesItr.next();
            sb.append("\"").append(service).append("\"");
        }
        while (servicesItr.hasNext()) {
            service = servicesItr.next();
            sb.append(",\"").append(service).append("\"");
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public HTTPResourceDescription copy() {
        return new HTTPResourceDescription(this.services, this.connections);
    }

    @Override
    public String getDynamicDescription() {
        return "{\"connections\":" + this.connections + "}";
    }

    @Override
    public boolean usesCPUs() {
        return false;
    }

    @Override
    public void scaleUpBy(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ERROR: Trying to scale by 0 or negative");
        }
        if (n > 1) {
            this.connections *= n;
        }
    }

    @Override
    public void scaleDownBy(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ERROR: Trying to scale by 0 or negative");
        }
        if (n > 1) {
            this.connections /= n;
        }
    }
}

