/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class DeleteDataRequest
implements APRequest {
    private final Application app;
    private final DataParams data;
    private final Semaphore sem;
    private ValueUnawareRuntimeException unawareException = null;
    private final boolean applicationDelete;

    public DeleteDataRequest(Application app, DataParams data, boolean applicationDelete) {
        this.app = app;
        this.data = data;
        this.sem = new Semaphore(0);
        this.applicationDelete = applicationDelete;
    }

    @Override
    public void process(AccessProcessor ap, TaskDispatcher td) {
        try {
            LOGGER.info("[DeleteDataRequest] Deleting Data in Task Analyser");
            DataInfo dataInfo = this.data.delete(this.app);
            int dataId = dataInfo.getDataId();
            LOGGER.info("Deleting data " + dataId);
            if (this.applicationDelete) {
                this.app.getCP().deletedData(dataInfo);
            }
        }
        catch (ValueUnawareRuntimeException vure) {
            this.unawareException = vure;
        }
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DELETE_DATA;
    }
}

