/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.PrivateLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.location.SharedDisk;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SharedLocation
extends DataLocation {
    private final String diskName;
    private final SharedDisk disk;
    private String path;
    private final ProtocolType protocol;

    public SharedLocation(ProtocolType protocol, String sharedDisk, String path) {
        this.diskName = sharedDisk;
        this.disk = SharedDisk.createDisk(sharedDisk);
        this.path = path;
        this.protocol = protocol;
    }

    public SharedLocation(ProtocolType protocol, SharedDisk sharedDisk, String path) {
        this.disk = sharedDisk;
        this.diskName = sharedDisk.getName();
        this.path = path;
        this.protocol = protocol;
    }

    @Override
    public MultiURI getURIInHost(Resource host) {
        String diskPath = this.disk.getMountpoint(host);
        if (diskPath == null) {
            return null;
        }
        if (!diskPath.endsWith(File.separator)) {
            diskPath = diskPath + File.separator;
        }
        return new MultiURI(this.protocol, host, diskPath + this.path);
    }

    @Override
    public LocationType getType() {
        return LocationType.SHARED;
    }

    @Override
    public ProtocolType getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MultiURI> getURIs() {
        String[] mountpoints;
        Resource[] resources;
        LinkedList<MultiURI> uris = new LinkedList<MultiURI>();
        Map<Resource, String> resList = this.disk.getAllMountpoints();
        int size = 0;
        Map<Resource, String> map = resList;
        synchronized (map) {
            size = resList.size();
            resources = new Resource[size];
            mountpoints = new String[size];
            int idx = 0;
            for (Map.Entry<Resource, String> e : resList.entrySet()) {
                resources[idx] = e.getKey();
                mountpoints[idx] = e.getValue();
                ++idx;
            }
        }
        for (int i = 0; i < size; ++i) {
            Resource host = resources[i];
            String diskPath = mountpoints[i];
            if (!diskPath.endsWith(File.separator)) {
                diskPath = diskPath + File.separator;
            }
            uris.add(new MultiURI(this.protocol, host, diskPath + this.path));
        }
        return uris;
    }

    @Override
    public List<Resource> getHosts() {
        return this.disk.getAllResources();
    }

    @Override
    public boolean isTarget(DataLocation target) {
        String targetPath;
        String targetDisk;
        if (target.getType().equals((Object)LocationType.PRIVATE)) {
            PrivateLocation privateLoc = (PrivateLocation)target;
            targetDisk = null;
            targetPath = privateLoc.getPath();
        } else {
            SharedLocation sharedloc = (SharedLocation)target;
            targetDisk = sharedloc.diskName;
            targetPath = sharedloc.path;
        }
        return targetDisk != null && targetDisk.contentEquals(this.diskName) && targetPath.contentEquals(targetPath);
    }

    @Override
    public SharedDisk getSharedDisk() {
        return this.disk;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getLocationKey() {
        return this.path + ":shared:" + this.diskName;
    }

    @Override
    public int compareTo(DataLocation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o.getClass() != SharedLocation.class) {
            return this.getClass().getName().compareTo(SharedLocation.class.toString());
        }
        SharedLocation sl = (SharedLocation)o;
        int compare = this.diskName.compareTo(sl.diskName);
        if (compare == 0) {
            compare = this.path.compareTo(sl.path);
        }
        return compare;
    }

    public String toString() {
        return "shared://" + this.diskName + File.separator + this.path;
    }

    @Override
    public void modifyPath(String path) {
        this.path = path;
    }
}

