/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.TaskListener;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class RegisterDataAccessRequest
extends APRequest
implements TaskListener {
    private final AccessParams accessParams;
    private DataAccessId accessId;
    private int pendingOperation = 0;
    private boolean released = false;
    private ValueUnawareRuntimeException unawareException = null;
    private final Semaphore sem;

    public RegisterDataAccessRequest(AccessParams access) {
        this.accessParams = access;
        this.sem = new Semaphore(0);
    }

    public AccessParams getAccessParams() {
        return this.accessParams;
    }

    public AccessParams.AccessMode getTaskAccessMode() {
        return this.accessParams.getMode();
    }

    public DataAccessId getAccessId() {
        return this.accessId;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        try {
            this.accessId = ta.processMainAccess(this);
        }
        catch (ValueUnawareRuntimeException e) {
            this.unawareException = e;
        }
        if (this.pendingOperation == 0) {
            this.notifyReady();
        }
        this.sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() throws ValueUnawareRuntimeException {
        this.sem.acquireUninterruptibly();
        boolean stalled = false;
        Application app = this.accessParams.getApp();
        RegisterDataAccessRequest registerDataAccessRequest = this;
        synchronized (registerDataAccessRequest) {
            LOGGER.info("App " + app.getId() + " waits for data to be produced");
            if (!this.released) {
                LOGGER.info("App " + app.getId() + " releases its resources.");
                stalled = true;
                app.stalled();
            }
        }
        LOGGER.info("App " + app.getId() + " awaits for data to be produced.");
        this.sem.acquireUninterruptibly();
        LOGGER.info("App " + app.getId() + " waiting data is produced.");
        if (stalled) {
            LOGGER.info("App " + app.getId() + " waits for resources.");
            app.readyToContinue(this.sem);
            this.sem.acquireUninterruptibly();
            LOGGER.info("App " + app.getId() + " resources are ready.");
        }
        if (this.unawareException != null) {
            throw this.unawareException;
        }
    }

    public void addPendingOperation() {
        ++this.pendingOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskFinished() {
        RegisterDataAccessRequest registerDataAccessRequest = this;
        synchronized (registerDataAccessRequest) {
            --this.pendingOperation;
            if (this.pendingOperation == 0) {
                this.notifyReady();
            }
        }
    }

    private void notifyReady() {
        if (this.accessId != null) {
            int dataId = this.accessId.getDataId();
            if (DEBUG) {
                LOGGER.debug("Data " + dataId + " available for main access");
            }
            this.accessId = this.accessId.consolidateValidVersions();
        } else if (DEBUG) {
            LOGGER.debug("Inexisting data");
        }
        this.released = true;
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.REGISTER_DATA_ACCESS;
    }
}

