/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.access;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MainAccess<V, D extends DataParams, P extends AccessParams<D>> {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.API");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final P parameters;

    protected MainAccess(P params) {
        this.parameters = params;
    }

    public final P getParameters() {
        return this.parameters;
    }

    public abstract V getUnavailableValueResponse();

    public abstract V fetch(DataAccessId var1);

    public abstract boolean isAccessFinishedOnRegistration();

    protected static DataLocation createLocalLocation(SimpleURI targetURI) {
        DataLocation targetLocation = null;
        try {
            targetLocation = DataLocation.createLocation(Comm.getAppHost(), targetURI);
        }
        catch (IOException ioe) {
            ErrorManager.error("ERROR: Invalid location URI " + targetURI, ioe);
        }
        return targetLocation;
    }
}

