/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.ObjectInfo;
import es.bsc.compss.types.data.params.DataParams;

public class ObjectData
extends DataParams {
    protected final int code;

    public ObjectData(Application app, int code) {
        super(app);
        this.code = code;
    }

    @Override
    public Integer getDataId() {
        Application app = this.getApp();
        return app.getObjectDataId(this.code);
    }

    @Override
    public String getDescription() {
        return "object with code " + this.code;
    }

    @Override
    public DataInfo createDataInfo() {
        ObjectInfo oInfo = new ObjectInfo(this);
        Application app = this.getApp();
        app.registerObjectData(this.code, oInfo);
        return oInfo;
    }

    @Override
    public DataInfo getDataInfo() {
        Application app = this.getApp();
        return app.getObjectData(this.code);
    }

    @Override
    public DataInfo removeDataInfo() {
        Application app = this.getApp();
        return app.removeObjectData(this.code);
    }

    public final int getCode() {
        return this.code;
    }

    @Override
    public void deleteLocal() throws Exception {
    }
}

