/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.info.FileInfo;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Semaphore;

public class GetResultFilesRequest
extends APRequest {
    private final Application app;
    private final Semaphore sem;
    private final LinkedList<ResultFile> blockedData;

    public GetResultFilesRequest(Application app, Semaphore sem) {
        this.app = app;
        this.sem = sem;
        this.blockedData = new LinkedList();
    }

    public Application getApp() {
        return this.app;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public LinkedList<ResultFile> getBlockedData() {
        return this.blockedData;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        ResultListener listener = new ResultListener(this.sem);
        Set<FileInfo> writtenData = this.app.getWrittenFiles();
        if (writtenData != null) {
            for (FileInfo fInfo : writtenData) {
                ResultFile rf = dip.blockDataAndGetResultFile(fInfo, listener);
                if (rf == null) continue;
                this.blockedData.add(rf);
            }
            listener.enable();
        } else {
            this.sem.release();
        }
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.BLOCK_AND_GET_RESULT_FILES;
    }
}

