/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.FileInfo;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DirectoryTransferable;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.NonExistingValueException;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class DataInfoProvider {
    private static final String RES_FILE_TRANSFER_ERR = "Error transferring result files";
    private TreeMap<Integer, DataInfo> idToData = new TreeMap();
    private TreeSet<String> valuesOnMain = new TreeSet();
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public DataInfoProvider() {
        LOGGER.info("Initialization finished");
    }

    private DataInfo registerData(DataParams data) {
        DataInfo dInfo = data.createDataInfo();
        this.idToData.put(dInfo.getDataId(), dInfo);
        return dInfo;
    }

    private void deregisterData(DataInfo di) {
        int dataId = di.getDataId();
        this.idToData.remove(dataId);
    }

    public void registerRemoteDataSources(DataParams internalData, String externalData) {
        DataInfo dInfo = internalData.getDataInfo();
        if (dInfo == null) {
            if (DEBUG) {
                LOGGER.debug("Registering Remote data on DIP: " + internalData.getDescription());
            }
            dInfo = this.registerData(internalData);
        }
        if (externalData != null && dInfo != null) {
            String existingRename = dInfo.getCurrentDataVersion().getDataInstanceId().getRenaming();
            try {
                Comm.linkData(externalData, existingRename);
            }
            catch (CommException ce) {
                ErrorManager.error("Could not link the newly created data for " + internalData.getDescription() + " with data " + externalData, ce);
            }
        }
    }

    public LogicalData getDataLastVersion(DataParams internalData) {
        DataInfo dInfo = internalData.getDataInfo();
        if (dInfo != null) {
            return dInfo.getCurrentDataVersion().getDataInstanceId().getData();
        }
        return null;
    }

    public DataAccessId registerAccessToExistingData(AccessParams access) throws ValueUnawareRuntimeException {
        access.checkAccessValidity(this);
        return this.registerDataAccess(access);
    }

    public DataAccessId registerDataAccess(AccessParams access) {
        DataInfo dInfo = access.getDataInfo();
        if (dInfo == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to " + access.getDataDescription());
            }
            dInfo = this.registerData((DataParams)access.getData());
            access.registeredAsFirstVersionForData(dInfo);
        } else if (DEBUG) {
            LOGGER.debug("Another access to " + access.getDataDescription());
        }
        DataAccessId daId = this.willAccess(access, dInfo);
        return daId;
    }

    public void finishDataAccess(AccessParams access, DataInstanceId generatedData) {
        DataInfo dInfo;
        if (generatedData != null && access.resultRemainOnMain()) {
            this.valuesOnMain.add(generatedData.getRenaming());
        }
        if ((dInfo = access.getDataInfo()) == null) {
            LOGGER.warn(access.getDataDescription() + " has not been accessed before");
            return;
        }
        DataAccessId daid = this.getAccess(access.getMode(), dInfo);
        if (daid == null) {
            LOGGER.warn(access.getDataDescription() + " has not been accessed before");
            return;
        }
        this.dataHasBeenAccessed(daid);
    }

    private DataAccessId willAccess(AccessParams access, DataInfo di) {
        DataAccessId daId = null;
        switch (access.getMode()) {
            case C: 
            case R: {
                di.willBeRead();
                daId = new RAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: R").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RAccessId)daId).getRVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case W: {
                di.willBeWritten();
                daId = new WAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: W").append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((WAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case CV: 
            case RW: {
                di.willBeRead();
                DataVersion readInstance = di.getCurrentDataVersion();
                di.willBeWritten();
                DataVersion writtenInstance = di.getCurrentDataVersion();
                if (readInstance != null) {
                    daId = new RWAccessId(readInstance, writtenInstance);
                    if (!DEBUG) break;
                    StringBuilder sb = new StringBuilder("");
                    sb.append("Access:").append("\n");
                    sb.append("  * Type: RW").append("\n");
                    sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getRVersionId()).append("\n");
                    sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getWVersionId()).append("\n");
                    LOGGER.debug(sb.toString());
                    break;
                }
                ErrorManager.warn("Previous instance for data" + di.getDataId() + " is null.");
            }
        }
        access.externalRegister();
        return daId;
    }

    private DataAccessId getAccess(AccessParams.AccessMode mode, DataInfo di) {
        DataAccessId daId = null;
        DataVersion currentInstance = di.getCurrentDataVersion();
        if (currentInstance != null) {
            switch (mode) {
                case C: 
                case R: {
                    daId = new RAccessId(currentInstance);
                    break;
                }
                case W: {
                    daId = new WAccessId(di.getCurrentDataVersion());
                    break;
                }
                case CV: 
                case RW: {
                    DataVersion readInstance = di.getPreviousDataVersion();
                    if (readInstance != null) {
                        daId = new RWAccessId(readInstance, currentInstance);
                        break;
                    }
                    LOGGER.warn("Previous instance for data" + di.getDataId() + " is null.");
                }
            }
        } else {
            LOGGER.warn("Current instance for data" + di.getDataId() + " is null.");
        }
        return daId;
    }

    public void dataAccessHasBeenCanceled(DataAccessId dAccId, boolean keepModified) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = this.idToData.get(dataId);
        if (di != null) {
            boolean deleted = false;
            switch (dAccId.getDirection()) {
                case C: 
                case R: {
                    Integer rVersionId = ((RAccessId)dAccId).getReadDataInstance().getVersionId();
                    deleted = di.canceledReadVersion(rVersionId);
                    break;
                }
                case CV: 
                case RW: {
                    Integer rVersionId = ((RWAccessId)dAccId).getReadDataInstance().getVersionId();
                    Integer wVersionId = ((RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                    if (keepModified) {
                        di.versionHasBeenRead(rVersionId);
                        di.tryRemoveVersion(rVersionId);
                        deleted = di.versionHasBeenWritten(wVersionId);
                        break;
                    }
                    di.canceledReadVersion(rVersionId);
                    deleted = di.canceledWriteVersion(wVersionId);
                    break;
                }
                default: {
                    Integer wVersionId = ((WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                    deleted = di.canceledWriteVersion(wVersionId);
                }
            }
            if (deleted) {
                this.deregisterData(di);
            }
        } else {
            LOGGER.debug("Access of Data" + dAccId.getDataId() + " in Mode " + dAccId.getDirection().name() + " can not be cancelled because do not exist in DIP.");
        }
    }

    public void dataHasBeenAccessed(DataAccessId dAccId) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = this.idToData.get(dataId);
        if (di != null) {
            Integer rVersionId = null;
            boolean deleted = false;
            if (dAccId.isRead()) {
                rVersionId = ((DataAccessId.ReadingDataAccessId)dAccId).getReadDataInstance().getVersionId();
                deleted = di.versionHasBeenRead(rVersionId);
            }
            if (dAccId.isWrite()) {
                Integer wVersionId = ((DataAccessId.WritingDataAccessId)dAccId).getWrittenDataInstance().getVersionId();
                if (rVersionId == null) {
                    rVersionId = wVersionId - 1;
                }
                di.tryRemoveVersion(rVersionId);
                deleted = di.versionHasBeenWritten(wVersionId);
            }
            if (deleted) {
                this.deregisterData(di);
            }
        } else {
            LOGGER.warn("Access of Data" + dAccId.getDataId() + " in Mode " + dAccId.getDirection().name() + "can not be mark as accessed because do not exist in DIP.");
        }
    }

    public boolean alreadyAccessed(DataParams data) {
        LOGGER.debug("Check already accessed: " + data.getDescription());
        DataInfo dInfo = data.getDataInfo();
        return dInfo != null;
    }

    public boolean isHere(DataParams data) {
        DataInfo oInfo = data.getDataInfo();
        DataInstanceId dId = oInfo.getCurrentDataVersion().getDataInstanceId();
        return this.valuesOnMain.contains(dId.getRenaming());
    }

    public void waitForDataReadyToDelete(DataParams data, Semaphore sem) throws ValueUnawareRuntimeException, NonExistingValueException {
        LOGGER.debug("Waiting for data " + data.getDescription() + " to be ready for deletion");
        DataInfo dataInfo = data.getDataInfo();
        if (dataInfo == null) {
            if (DEBUG) {
                LOGGER.debug("No data found for data associated to " + data.getDescription());
            }
            throw new ValueUnawareRuntimeException();
        }
        dataInfo.waitForDataReadyToDelete(sem);
    }

    public DataInfo deleteData(DataParams data) throws ValueUnawareRuntimeException {
        DataInfo dataInfo;
        if (DEBUG) {
            LOGGER.debug("Deleting Data associated to " + data.getDescription());
        }
        if ((dataInfo = data.removeDataInfo()) == null) {
            if (DEBUG) {
                LOGGER.debug("No data found for data associated to " + data.getDescription());
            }
            throw new ValueUnawareRuntimeException();
        }
        if (dataInfo.delete()) {
            this.deregisterData(dataInfo);
        }
        return dataInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultFile blockDataAndGetResultFile(FileInfo fInfo, ResultListener listener) {
        int dataId = fInfo.getDataId();
        if (DEBUG) {
            LOGGER.debug("Get Result file for data " + dataId);
        }
        if (fInfo.hasBeenCanceled()) {
            if (!fInfo.isCurrentVersionToDelete()) {
                String[] splitPath = fInfo.getOriginalLocation().getPath().split(File.separator);
                String origName = splitPath[splitPath.length - 1];
                if (origName.startsWith("compss-serialized-obj_")) {
                    if (DEBUG) {
                        LOGGER.debug("Discarding file " + origName + " as a result");
                    }
                    return null;
                }
                fInfo.blockDeletions();
                DataInstanceId lastVersion = fInfo.getCurrentDataVersion().getDataInstanceId();
                ResultFile rf = new ResultFile(fInfo, lastVersion, fInfo.getOriginalLocation());
                String renaming = lastVersion.getRenaming();
                while (renaming != null && !Comm.existsData(renaming)) {
                    renaming = DataInstanceId.previousVersionRenaming(renaming);
                }
                if (renaming == null) {
                    LOGGER.error("Error transferring result files: Cannot transfer file " + lastVersion.getRenaming() + " nor any of its previous versions");
                    return null;
                }
                LogicalData data = Comm.getData(renaming);
                for (DataLocation loc : data.getLocations()) {
                    if (!(loc instanceof PersistentLocation)) continue;
                    String pscoId = ((PersistentLocation)loc).getId();
                    if (Tracer.isActivated()) {
                        Tracer.emitEvent(TraceEvent.STORAGE_CONSOLIDATE);
                    }
                    try {
                        StorageItf.consolidateVersion(pscoId);
                    }
                    catch (StorageException e) {
                        LOGGER.error("Cannot consolidate PSCO " + pscoId, (Throwable)e);
                    }
                    finally {
                        if (Tracer.isActivated()) {
                            Tracer.emitEventEnd(TraceEvent.STORAGE_CONSOLIDATE);
                        }
                    }
                    LOGGER.debug("Returned because persistent object");
                    return rf;
                }
                if (rf.getOriginalLocation().getProtocol() == ProtocolType.BINDING_URI) {
                    if (DEBUG) {
                        LOGGER.debug("Discarding data d" + dataId + " as a result beacuse it is a binding object");
                    }
                } else if (rf.getOriginalLocation().getProtocol() == ProtocolType.DIR_URI) {
                    listener.addOperation();
                    Comm.getAppHost().getData(data, rf.getOriginalLocation(), (Transferable)new DirectoryTransferable(), (EventListener)listener);
                } else {
                    listener.addOperation();
                    Comm.getAppHost().getData(data, rf.getOriginalLocation(), (Transferable)new FileTransferable(), (EventListener)listener);
                }
                return rf;
            }
            if (fInfo.isCurrentVersionToDelete()) {
                if (DEBUG) {
                    String[] splitPath = fInfo.getOriginalLocation().getPath().split(File.separator);
                    String origName = splitPath[splitPath.length - 1];
                    LOGGER.debug("Trying to delete file " + origName);
                }
                if (fInfo.delete()) {
                    this.deregisterData(fInfo);
                }
            }
        }
        return null;
    }

    public void shutdown() {
    }
}

