/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.ReduceTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.parameter.impl.CollectiveParameter;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.parameter.impl.FileParameter;
import es.bsc.compss.types.parameter.impl.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReduceExecutionAction
extends ExecutionAction {
    private static final String LOG_PREFIX = "[Reduce-Execution-Action] ";
    private TaskScheduler ts;
    private int reduceIndex = 0;
    private CollectiveParameter initialCollection;
    private Set<Parameter> extraParameters;
    private Map<Resource, List<Parameter>> parametersInResource;
    private List<AllocatableAction> alreadyDoneActions;
    private Map<AllocatableAction, Parameter> partialParameters;
    private boolean finalTaskExecuted;
    private List<Resource> finalInResource;
    private int receivedOriginalParameters = 0;
    private List<Resource> usedResources;
    private Map<Resource, List<AllocatableAction>> executingInResource;
    private int colIndex;
    private Set<Integer> partialTaskIds;

    public ReduceExecutionAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, AccessProcessor ap, ReduceTask task, TaskScheduler ts) {
        super(schedulingInformation, orchestrator, ap, task);
        if (this.parametersInResource == null) {
            this.parametersInResource = new HashMap<Resource, List<Parameter>>();
        }
        this.ts = ts;
        this.extraParameters = new HashSet<Parameter>();
        this.partialTaskIds = new HashSet<Integer>();
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        this.colIndex = task.getReduceCollectionIndex();
        for (int i = 0; i < finalParameters.size() - 1; ++i) {
            if (i == this.colIndex) {
                this.initialCollection = (CollectiveParameter)finalParameters.get(this.colIndex);
                continue;
            }
            this.extraParameters.add(finalParameters.get(i));
        }
        this.partialParameters = new HashMap<AllocatableAction, Parameter>();
        this.finalTaskExecuted = false;
        this.usedResources = new ArrayList<Resource>();
        LOGGER.debug("[Reduce-Execution-Action] Creating new Reduce execution action for Task " + this.task.getId());
        this.executingInResource = new HashMap<Resource, List<AllocatableAction>>();
        this.finalInResource = new ArrayList<Resource>();
        if (this.alreadyDoneActions != null) {
            this.alreadyDonePredecessors();
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Parameter p : task.getFreeParams()) {
            if (p.isCollective() || p instanceof FileParameter && ((FileParameter)p).getOriginalName().startsWith("reduce") || this.extraParameters.contains(p)) continue;
            params.add(p);
        }
        this.addNonDependentParam(params);
    }

    private void addNonDependentParam(List<Parameter> params) {
        for (Parameter p : params) {
            Resource r = null;
            if (p.isPotentialDependency()) {
                r = this.getParameterLocation((DependencyParameter)p);
                if (r == null) {
                    r = this.assignResourceToFreeParam();
                }
            } else {
                r = this.assignResourceToFreeParam();
            }
            if (r == null) continue;
            this.parametersInResource.get(r).add(p);
            if (!this.usedResources.contains(r)) {
                this.usedResources.add(r);
            }
            ++this.receivedOriginalParameters;
            this.addReduceTaskParameters(r);
        }
    }

    private Resource assignResourceToFreeParam() {
        Resource r = null;
        HashSet<Resource> hosts = new HashSet<Resource>();
        for (ResourceScheduler<? extends WorkerResourceDescription> rs : this.ts.getWorkers()) {
            hosts.add(rs.getResource());
        }
        r = this.getBestHost(r, hosts);
        return r;
    }

    private Resource getParameterLocation(DependencyParameter dp) {
        LogicalData dataLD;
        DataInstanceId dId = null;
        DataAccessId access = dp.getDataAccessId();
        if (access.isRead()) {
            DataAccessId.ReadingDataAccessId raId = (DataAccessId.ReadingDataAccessId)dp.getDataAccessId();
            dId = raId.getReadDataInstance();
        }
        Resource maxResource = null;
        if (dId != null && (dataLD = dId.getData()) != null) {
            Set<Resource> hosts = dataLD.getAllHosts();
            maxResource = this.getBestHost(maxResource, hosts);
        }
        return maxResource;
    }

    private Resource getBestHost(Resource maxResource, Set<Resource> hosts) {
        if (!hosts.isEmpty()) {
            maxResource = hosts.iterator().next();
            for (Resource host : hosts) {
                this.checkAndRegisterResource(host);
                if (this.parametersInResource.get(maxResource).size() >= this.parametersInResource.get(host).size()) continue;
                maxResource = host;
            }
        }
        if (DEBUG) {
            LOGGER.debug("[Reduce-Execution-Action] Chosen host to run the reduce: " + (maxResource != null ? maxResource.toString() : "null"));
        }
        return maxResource;
    }

    @Override
    public void addAlreadyDoneAction(AllocatableAction finishedAction) {
        LOGGER.debug("[Reduce-Execution-Action] Registering a dependenant action was already done action for Task " + this.getTask().getId());
        if (this.alreadyDoneActions == null) {
            this.alreadyDoneActions = new ArrayList<AllocatableAction>();
        }
        this.alreadyDoneActions.add(finishedAction);
    }

    private void alreadyDonePredecessors() {
        LOGGER.debug("[Reduce-Execution-Action] Treating already done action actions for " + this.getTask().getId());
        for (AllocatableAction a : this.alreadyDoneActions) {
            this.registerPredecessorDone(a);
        }
    }

    @Override
    protected void dataPredecessorDone(AllocatableAction finishedAction) {
        this.registerPredecessorDone(finishedAction);
        super.dataPredecessorDone(finishedAction);
    }

    public void registerPredecessorDone(AllocatableAction finishedAction) {
        Parameter param;
        LOGGER.debug("[Reduce-Execution-Action] Registering predecessor done for Task " + this.getTask().getId());
        Worker<? extends WorkerResourceDescription> resource = finishedAction.getAssignedResource().getResource();
        this.checkAndRegisterResource(resource);
        Task finishedTask = ((ExecutionAction)finishedAction).getTask();
        boolean isReduceParam = false;
        if (!this.partialTaskIds.contains(finishedTask.getId())) {
            this.partialTaskIds.remove(finishedTask.getId());
            param = this.getTask().getDependencyParameters(finishedTask);
            if (!this.extraParameters.contains(param)) {
                isReduceParam = true;
                ++this.receivedOriginalParameters;
            }
        } else {
            isReduceParam = true;
            param = this.partialParameters.remove(finishedAction);
            List<AllocatableAction> actions = this.executingInResource.get(resource);
            actions.remove(finishedAction);
        }
        if (isReduceParam) {
            this.parametersInResource.get(resource).add(param);
            if (!this.usedResources.contains(resource)) {
                this.usedResources.add(resource);
            }
        }
        this.addReduceTaskParameters(resource);
    }

    private void checkAndRegisterResource(Resource resource) {
        if (!this.parametersInResource.containsKey(resource)) {
            ArrayList parameters = new ArrayList();
            this.parametersInResource.put(resource, parameters);
        }
    }

    private void addReduceTaskParameters(Resource resource) {
        List<Parameter> params = this.parametersInResource.get(resource);
        if (!this.finalTaskExecuted) {
            if (this.noMoreOriginalReductionParamsPending()) {
                if (this.mustLaunchFinalTasks()) {
                    this.launchFinalTasks();
                } else {
                    List<AllocatableAction> actions = this.executingInResource.get(resource);
                    if (actions == null || actions.isEmpty()) {
                        LOGGER.debug("No partial reduces running in the resource. Trying to launch a final task in resource " + resource.getName());
                        this.finalTaskInResource(resource);
                    } else if (params.size() >= this.getChunkSize()) {
                        this.launchReduceAction(resource, params);
                        ++this.reduceIndex;
                        this.parametersInResource.put(resource, new ArrayList());
                    }
                }
            } else if (params.size() >= this.getChunkSize()) {
                this.launchReduceAction(resource, params);
                ++this.reduceIndex;
                this.parametersInResource.put(resource, new ArrayList());
            }
        }
    }

    private void launchFinalTasks() {
        LOGGER.debug("[Reduce-Execution-Action] Launching final tasks for Task " + this.getTask().getId());
        ArrayList<Parameter> finalParams = new ArrayList<Parameter>();
        this.finalTaskExecuted = true;
        if (this.usedResources.size() > 1) {
            for (Resource resource : this.parametersInResource.keySet()) {
                if (this.finalInResource.contains(resource)) continue;
                this.finalTaskInResource(resource);
            }
        }
        for (Map.Entry entry : this.parametersInResource.entrySet()) {
            finalParams.addAll((Collection)entry.getValue());
        }
        this.setFinalExecutionParameters(finalParams);
        this.finalTaskExecuted = true;
    }

    private int getChunkSize() {
        return ((ReduceTask)this.task).getChunkSize();
    }

    private boolean mustLaunchFinalTasks() {
        return this.partialParameters.size() == 0 && this.usedResources.size() > 1 || this.usedResources.size() == 1 && this.partialParameters.size() + this.parametersInResource.get(this.usedResources.get(0)).size() <= this.getChunkSize();
    }

    private boolean noMoreOriginalReductionParamsPending() {
        return this.initialCollection != null && this.receivedOriginalParameters == this.initialCollection.getElements().size();
    }

    private void finalTaskInResource(Resource resource) {
        LOGGER.debug("[Reduce-Execution-Action] Trying to generate final reduce for resource " + resource.getName() + " of Task " + this.task.getId());
        List<Parameter> params = this.parametersInResource.get(resource);
        if (params.size() > 1) {
            this.launchReduceAction(resource, params);
            ++this.reduceIndex;
            this.parametersInResource.put(resource, new ArrayList());
            this.finalInResource.add(resource);
        }
    }

    private void setFinalExecutionParameters(List<Parameter> params) {
        LOGGER.debug("[Reduce-Execution-Action] Creating final reduce task for Task " + this.task.getId());
        ReduceTask t = (ReduceTask)this.task;
        ArrayList<Parameter> partialsIn = new ArrayList<Parameter>(this.partialParameters.values());
        for (Parameter p : params) {
            partialsIn.add(p);
        }
        CollectiveParameter cPartial = t.getFinalCollection();
        cPartial.setElements((List<Parameter>)partialsIn);
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(this.colIndex, cPartial);
    }

    private void launchReduceAction(Resource resource, List<Parameter> params) {
        LOGGER.debug("[Reduce-Execution-Action] Creating partial reduce task for Task " + this.task.getId());
        ReduceTask t = (ReduceTask)this.task;
        if (this.reduceIndex >= t.getIntermediateCollections().size()) {
            LOGGER.error("ERROR: Reduce Task " + this.task.getId() + " has exceed the number of partial reduces");
            ErrorManager.fatal("ERROR: Reduce task " + this.task.getId() + " has exceed the number of partial reduces");
        }
        CollectiveParameter cp = t.getIntermediateCollections().get(this.reduceIndex);
        cp.setElements(params);
        ArrayList<Parameter> taskP = new ArrayList<Parameter>();
        TaskDescription<Parameter> td = this.task.getTaskDescription();
        List<Parameter> oldParameters = td.getParameters();
        for (int i = 0; i < oldParameters.size() - 1; ++i) {
            if (i == this.colIndex) {
                taskP.add(cp);
                continue;
            }
            taskP.add(oldParameters.get(i));
        }
        Parameter result = t.getIntermediateOutParameters().get(0);
        t.setPartialOutUsed(result);
        Parameter partialIn = t.getIntermediateInParameters().get(0);
        t.setPartialInUsed(partialIn);
        taskP.add(result);
        Task partialTask = new Task(this.task.getApplication(), td.getLang(), td.getName(), td.hasPriority(), td.getNumNodes(), td.isReduction(), td.isReplicated(), td.isDistributed(), td.hasTargetObject(), td.getNumReturns(), taskP, this.task.getTaskMonitor(), td.getOnFailure(), td.getTimeOut());
        this.partialTaskIds.add(partialTask.getId());
        LOGGER.debug("[Reduce-Execution-Action] Task " + partialTask.getId() + " is a partial reduce task for Task " + this.task.getId() + ". Adding as predecessor");
        ResourceScheduler<? extends WorkerResourceDescription> partialReduceScheduler = this.ts.getWorkers().iterator().next();
        for (ResourceScheduler<? extends WorkerResourceDescription> rs : this.ts.getWorkers()) {
            if (rs.getResource() != resource) continue;
            partialReduceScheduler = rs;
            break;
        }
        ExecutionAction partialReduceAction = new ExecutionAction(this.ts.generateSchedulingInformation(partialReduceScheduler, taskP, td.getCoreElement().getCoreId()), this.orchestrator, this.ap, partialTask);
        int previous = this.getDataPredecessors().size();
        this.addDataPredecessor(partialReduceAction);
        LOGGER.debug("Current predec: " + this.getDataPredecessors().size() + " previous: " + previous);
        this.partialParameters.put(partialReduceAction, partialIn);
        this.ts.newAllocatableAction(partialReduceAction);
        this.addExecutingToResource(partialReduceAction, resource);
    }

    private void addExecutingToResource(AllocatableAction partialReduceAction, Resource resource) {
        List<Object> actions;
        if (!this.executingInResource.containsKey(resource)) {
            actions = new ArrayList();
            this.executingInResource.put(resource, actions);
        }
        actions = this.executingInResource.get(resource);
        actions.add(partialReduceAction);
    }

    @Override
    protected void doCompleted() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(this.colIndex, this.initialCollection);
        ((ReduceTask)this.task).clearPartials();
        super.doCompleted();
    }

    @Override
    protected void doFailed() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(this.colIndex, this.initialCollection);
        super.doFailed();
    }

    @Override
    protected void doCanceled() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(this.colIndex, this.initialCollection);
        super.doCanceled();
    }

    @Override
    protected void doFailIgnored() {
        List<Parameter> finalParameters = this.task.getTaskDescription().getParameters();
        finalParameters.set(this.colIndex, this.initialCollection);
        super.doFailIgnored();
    }
}

