/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.CollectionInfo;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;

public class CollectionData
extends DataParams {
    private final String collectionId;

    public CollectionData(Application app, String collectionId) {
        super(app);
        this.collectionId = collectionId;
    }

    @Override
    public String getDescription() {
        return "collection  " + this.collectionId;
    }

    @Override
    public Integer getDataId() {
        Application app = this.getApp();
        return app.getCollectionDataId(this.collectionId);
    }

    @Override
    public DataInfo createDataInfo() {
        CollectionInfo cInfo = new CollectionInfo(this);
        Application app = this.getApp();
        app.registerCollectionData(this.collectionId, cInfo);
        return cInfo;
    }

    @Override
    public DataInfo getDataInfo() {
        Application app = this.getApp();
        return app.getCollectionData(this.collectionId);
    }

    @Override
    public DataInfo removeDataInfo() {
        Application app = this.getApp();
        return app.removeCollectionData(this.collectionId);
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    @Override
    public void deleteLocal() throws Exception {
    }
}

