/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.parameter.impl;

import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.accessparams.CollectionAccessParams;
import es.bsc.compss.types.data.params.CollectionData;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.parameter.impl.Parameter;
import java.util.Iterator;
import java.util.List;

public class CollectiveParameter
extends DependencyParameter<CollectionAccessParams>
implements es.bsc.compss.types.parameter.CollectiveParameter<Parameter> {
    private static final long serialVersionUID = 1L;
    private List<Parameter> elements;

    public static final CollectiveParameter newCP(Application app, DataType type, String id, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename, ParameterMonitor monitor, List<Parameter> elements) {
        CollectionAccessParams cap = CollectionAccessParams.constructCAP(app, direction, id);
        return new CollectiveParameter(cap, type, direction, stream, prefix, name, contentType, weight, keepRename, monitor, elements);
    }

    protected CollectiveParameter(CollectionAccessParams cap, DataType type, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename, ParameterMonitor monitor, List<Parameter> elements) {
        super(cap, type, direction, stream, prefix, name, contentType, weight, keepRename, monitor);
        this.elements = elements;
    }

    @Override
    public final boolean isCollective() {
        return true;
    }

    @Override
    public final String getCollectionId() {
        return ((CollectionData)((CollectionAccessParams)this.getAccess()).getData()).getCollectionId();
    }

    @Override
    public final List<Parameter> getElements() {
        return this.elements;
    }

    @Override
    public final void setElements(List<Parameter> elements) {
        this.elements = elements;
    }

    @Override
    public String toString() {
        if (this.getType() == DataType.COLLECTION_T) {
            return this.toCollectionString();
        }
        return this.toDictionaryString();
    }

    private String toDictionaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DictCollectionParameter ").append(this.getCollectionId()).append("\n");
        sb.append("Name: ").append(this.getName()).append("\n");
        sb.append("Contents:\n");
        Iterator<Parameter> it = this.getElements().iterator();
        while (it.hasNext()) {
            Parameter key = it.next();
            Parameter value = it.next();
            sb.append("\t").append(key).append(" - ").append(value).append("\n");
        }
        return sb.toString();
    }

    private String toCollectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CollectionParameter ").append(this.getCollectionId()).append("\n");
        sb.append("Name: ").append(this.getName()).append("\n");
        sb.append("Contents:\n");
        for (Parameter s : this.getElements()) {
            sb.append("\t").append(s).append("\n");
        }
        return sb.toString();
    }
}

