/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.ObjectData;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;

public class ObjectAccessParams<T, D extends ObjectData>
extends AccessParams<D> {
    private static final long serialVersionUID = 1L;
    private final T value;

    public static final <T> ObjectAccessParams<T, ObjectData> constructObjectAP(Application app, Direction dir, T value, int code) {
        return new ObjectAccessParams<T, ObjectData>(new ObjectData(app, code), dir, value);
    }

    protected ObjectAccessParams(D data, Direction dir, T value) {
        super(data, dir);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public final int getCode() {
        return ((ObjectData)this.data).getCode();
    }

    @Override
    public void checkAccessValidity(DataInfoProvider dip) throws ValueUnawareRuntimeException {
        boolean validValue = dip.isHere(this.data);
        if (validValue) {
            throw new ValueUnawareRuntimeException();
        }
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        DataVersion dv = dInfo.getCurrentDataVersion();
        if (this.mode != AccessParams.AccessMode.W) {
            DataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerValue(renaming, this.value);
        } else {
            dv.invalidate();
        }
    }

    @Override
    public boolean resultRemainOnMain() {
        return true;
    }

    @Override
    public void externalRegister() {
    }

    public String toString() {
        return "[" + this.getApp() + ", " + (Object)((Object)this.mode) + " ," + this.getCode() + "]";
    }
}

