/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.checkpoint.CheckpointManager;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.components.monitor.impl.NoGraph;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskListener;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.accesses.DataAccessesInfo;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.FileInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.parameter.impl.CollectiveParameter;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.parameter.impl.ObjectParameter;
import es.bsc.compss.types.parameter.impl.Parameter;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.util.ErrorManager;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class TaskAnalyser {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String TASK_FAILED = "Task failed: ";
    private static final String TASK_CANCELED = "Task canceled: ";
    private CheckpointManager cp;
    private GraphHandler gh;
    private final Map<Integer, DataAccessesInfo> accessesInfo = new TreeMap<Integer, DataAccessesInfo>();

    public TaskAnalyser() {
        LOGGER.info("Initialization finished");
        this.gh = new NoGraph();
    }

    public void setCoWorkers(CheckpointManager cp) {
        this.cp = cp;
    }

    public void setGM(GraphHandler gh) {
        this.gh = gh;
    }

    public void processTask(Task currentTask) {
        TaskDescription<Parameter> description = currentTask.getTaskDescription();
        LOGGER.info("New " + description.getType().toString().toLowerCase() + " task: Name:" + description.getName() + "), ID = " + currentTask.getId() + " APP = " + currentTask.getApplication().getId());
        this.gh.startTaskAnalysis(currentTask);
        Application app = currentTask.getApplication();
        app.newTask(currentTask);
        int constrainingParam = -1;
        boolean taskHasEdge = this.processTaskParameters(currentTask, constrainingParam);
        this.registerIntermediateParameter(currentTask);
        this.markIntermediateParametersToDelete(currentTask);
        this.gh.endTaskAnalysis(currentTask, taskHasEdge);
        this.cp.newTask(currentTask);
    }

    private boolean processTaskParameters(Task currentTask, int constrainingParam) {
        List<Parameter> parameters = currentTask.getParameters();
        boolean taskHasEdge = false;
        for (int paramIdx = 0; paramIdx < parameters.size(); ++paramIdx) {
            boolean isConstraining = paramIdx == constrainingParam;
            Parameter param = parameters.get(paramIdx);
            boolean paramHasEdge = this.registerParameterAccessAndAddDependencies(currentTask, param, isConstraining);
            taskHasEdge = taskHasEdge || paramHasEdge;
        }
        return taskHasEdge;
    }

    private void markIntermediateParametersToDelete(Task task) {
        for (Parameter p : task.getParameterDataToRemove()) {
            if (!p.isPotentialDependency()) continue;
            DependencyParameter dp = (DependencyParameter)p;
            try {
                ((DataParams)((AccessParams)dp.getAccess()).getData()).delete();
            }
            catch (ValueUnawareRuntimeException valueUnawareRuntimeException) {}
        }
    }

    private void registerIntermediateParameter(Task task) {
        for (Parameter p : task.getIntermediateParameters()) {
            this.registerParameterAccessAndAddDependencies(task, p, false);
        }
    }

    public void snapshot() {
        this.cp.snapshot();
    }

    public EngineDataAccessId processMainAccess(RegisterDataAccessRequest rdar) throws ValueUnawareRuntimeException {
        AccessParams access = rdar.getAccessParams();
        if (DEBUG) {
            LOGGER.debug("Registering access " + access.toString() + " from main code");
        }
        access.checkAccessValidity();
        EngineDataAccessId daId = access.register();
        if (daId == null) {
            if (DEBUG) {
                LOGGER.debug("Accessing a canceled data from main code. Returning null");
            }
            return null;
        }
        if (DEBUG) {
            LOGGER.debug("Registered access to data " + daId.getDataId() + " from main code");
        }
        if (daId.isRead()) {
            EngineDataAccessId.ReadingDataAccessId rdaId = (EngineDataAccessId.ReadingDataAccessId)daId;
            EngineDataInstanceId di = rdaId.getReadDataInstance();
            this.cp.mainAccess(di);
            int dataId = daId.getDataId();
            DataAccessesInfo dai = this.accessesInfo.get(dataId);
            if (dai != null) {
                EngineDataInstanceId depInstance = daId.isWrite() ? ((EngineDataAccessId.WritingDataAccessId)daId).getWrittenDataInstance() : di;
                dai.mainAccess(rdar, this.gh, depInstance);
            }
        }
        return daId;
    }

    public void endTask(AbstractTask aTask, boolean checkpointing) {
        int taskId = aTask.getId();
        long start = System.currentTimeMillis();
        if (aTask instanceof Task) {
            List<TaskListener> listeners;
            Task task = (Task)aTask;
            boolean isFree = task.isFree();
            TaskState taskState = task.getStatus();
            LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
            if (!isFree) {
                LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
                return;
            }
            switch (taskState) {
                case FAILED: {
                    OnFailure onFailure = task.getOnFailure();
                    if (onFailure == OnFailure.RETRY || onFailure == OnFailure.FAIL) {
                        ErrorManager.error(TASK_FAILED + task);
                        return;
                    }
                    if (onFailure != OnFailure.IGNORE && onFailure != OnFailure.CANCEL_SUCCESSORS) break;
                    ErrorManager.warn(TASK_FAILED + task);
                    break;
                }
                case CANCELED: {
                    ErrorManager.warn(TASK_CANCELED + task);
                    break;
                }
            }
            if (DEBUG) {
                LOGGER.debug("Marking accessed parameters for task " + taskId);
            }
            for (Parameter parameter : task.getTaskDescription().getParameters()) {
                this.updateParameter(task, parameter);
            }
            for (Parameter parameter : task.getUnusedIntermediateParameters()) {
                this.updateParameter(task, parameter);
            }
            if (DEBUG) {
                LOGGER.debug("Freeing barriers for task " + taskId);
            }
            if (DEBUG) {
                LOGGER.debug("Releasing waiting tasks for task " + taskId);
            }
            if ((listeners = task.getListeners()) != null) {
                for (TaskListener listener : listeners) {
                    listener.taskFinished();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Checking result file transfers for task " + taskId);
            }
            Application application = task.getApplication();
            application.endTask(task);
            TaskMonitor registeredMonitor = task.getTaskMonitor();
            switch (taskState) {
                case FAILED: {
                    registeredMonitor.onFailure();
                    break;
                }
                case CANCELED: {
                    registeredMonitor.onCancellation();
                    break;
                }
                default: {
                    registeredMonitor.onCompletion();
                }
            }
            this.releaseCommutativeGroups(task);
            if (!checkpointing) {
                if (DEBUG) {
                    LOGGER.debug("Checkpoint saving task " + taskId);
                }
                this.cp.endTask(task);
            }
        }
        if (DEBUG) {
            LOGGER.debug("Releasing data dependant tasks for task " + taskId);
        }
        aTask.releaseDataDependents();
        if (DEBUG) {
            long time = System.currentTimeMillis() - start;
            LOGGER.debug("Task " + taskId + " end message processed in " + time + " ms.");
        }
    }

    public void barrierGroup(BarrierGroupRequest request) {
        Application app = request.getApp();
        String groupName = request.getGroupName();
        app.reachesGroupBarrier(groupName, (Barrier)request);
        this.gh.groupBarrier(request);
    }

    public void barrier(BarrierRequest request) {
        Application app = request.getApp();
        app.reachesBarrier(request);
        this.gh.barrier(this.accessesInfo);
    }

    public void noMoreTasks(EndOfAppRequest request) {
        Application app = request.getApp();
        app.endReached(request);
        this.gh.endApp();
    }

    public void deleteData(DataParams data, boolean applicationDelete) throws ValueUnawareRuntimeException {
        DataAccessesInfo dai;
        DataInfo dataInfo = data.delete();
        int dataId = dataInfo.getDataId();
        LOGGER.info("Deleting data " + dataId);
        if (applicationDelete) {
            this.cp.deletedData(dataInfo);
        }
        if ((dai = this.accessesInfo.remove(dataId)) != null) {
            switch (dai.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    break;
                }
                case FILE_T: {
                    Application app = data.getApp();
                    FileInfo fInfo = (FileInfo)data.getRegisteredData();
                    app.removeWrittenFile(fInfo);
                    break;
                }
            }
        } else {
            LOGGER.warn("Writters info for data " + dataId + " not found.");
        }
    }

    public void shutdown() {
        this.gh.removeCurrentGraph();
        this.cp.shutdown();
    }

    public void setCurrentTaskGroup(Application app, String groupName) {
        app.stackTaskGroup(groupName);
        this.gh.openTaskGroup(groupName);
    }

    public void closeCurrentTaskGroup(Application app) {
        app.popGroup();
        this.gh.closeTaskGroup();
    }

    private void releaseCommutativeGroups(Task task) {
        if (!task.getCommutativeGroupList().isEmpty()) {
            for (CommutativeGroupTask group : task.getCommutativeGroupList()) {
                group.getCommutativeTasks().remove(task);
                group.setStatus(TaskState.FINISHED);
                group.removePredecessor(task);
                if (!group.getPredecessors().isEmpty()) continue;
                group.releaseDataDependents();
                List<TaskListener> listeners = group.getListeners();
                if (listeners != null) {
                    for (TaskListener listener : listeners) {
                        listener.taskFinished();
                    }
                }
                if (!DEBUG) continue;
                LOGGER.debug("Group " + group.getId() + " ended execution");
                LOGGER.debug("Data dependents of group " + group.getCommutativeIdentifier() + " released ");
            }
        }
    }

    private boolean registerParameterAccessAndAddDependencies(Task currentTask, Parameter p, boolean isConstraining) {
        ObjectParameter op;
        boolean hasParamEdge = false;
        if (p.isCollective()) {
            CollectiveParameter cp = (CollectiveParameter)p;
            this.gh.startGroupingEdges();
            for (Parameter content : cp.getElements()) {
                boolean hasCollectionParamEdge = this.registerParameterAccessAndAddDependencies(currentTask, content, isConstraining);
                hasParamEdge = hasParamEdge || hasCollectionParamEdge;
            }
            this.gh.stopGroupingEdges();
        } else if (p.getType() == DataType.OBJECT_T && (op = (ObjectParameter)p).getValue() instanceof StubItf && ((StubItf)op.getValue()).getID() != null) {
            op.setType(DataType.PSCO_T);
        }
        AccessParams access = p.getAccess();
        EngineDataAccessId daId = access != null ? access.register() : null;
        if (p.isCollective()) {
            try {
                this.deleteData((DataParams)access.getData(), false);
            }
            catch (ValueUnawareRuntimeException content) {
                // empty catch block
            }
        }
        if (daId != null) {
            DependencyParameter dp = (DependencyParameter)p;
            dp.setDataAccessId(daId);
            hasParamEdge = this.addDependencies(currentTask, isConstraining, dp);
        } else {
            currentTask.registerFreeParam(p);
        }
        return hasParamEdge;
    }

    private boolean addDependencies(Task currentTask, boolean isConstraining, DependencyParameter dp) {
        boolean hasParamEdge = false;
        EngineDataAccessId daId = dp.getDataAccessId();
        int dataId = daId.getDataId();
        DataAccessesInfo dai = this.accessesInfo.get(dataId);
        switch (((AccessParams)dp.getAccess()).getMode()) {
            case R: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                break;
            }
            case RW: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                this.registerOutputValues(currentTask, dp, false, dai);
                break;
            }
            case W: {
                this.registerOutputValues(currentTask, dp, false, dai);
                break;
            }
            case C: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, true, dataId, dai, isConstraining);
                this.registerOutputValues(currentTask, dp, true, dai);
                break;
            }
            case CV: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                this.registerOutputValues(currentTask, dp, false, dai);
            }
        }
        return hasParamEdge;
    }

    private boolean checkInputDependency(Task currentTask, DependencyParameter dp, boolean isConcurrent, int dataId, DataAccessesInfo dai, boolean isConstraining) {
        if (DEBUG) {
            LOGGER.debug("Checking READ dependency for datum " + dataId + " and task " + currentTask.getId());
        }
        boolean hasEdge = false;
        if (dai != null) {
            hasEdge = dai.readValue(currentTask, dp, isConcurrent, this.gh);
            if (isConstraining) {
                AbstractTask lastWriter = dai.getConstrainingProducer();
                currentTask.setEnforcingTask((Task)lastWriter);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            currentTask.registerFreeParam(dp);
        }
        return hasEdge;
    }

    private void registerOutputValues(Task currentTask, DependencyParameter dp, boolean isConcurrent, DataAccessesInfo dai) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Application app = currentTask.getApplication();
        if (DEBUG) {
            LOGGER.debug("Checking WRITE dependency for datum " + dataId + " and task " + currentTaskId);
        }
        if (dai == null) {
            dai = DataAccessesInfo.createAccessInfo(dp.getType());
            this.accessesInfo.put(dataId, dai);
        }
        dai.writeValue(currentTask, dp, isConcurrent, this.gh);
        switch (dp.getType()) {
            case FILE_T: 
            case DIRECTORY_T: {
                FileInfo fInfo = (FileInfo)((AccessParams)dp.getAccess()).getDataInfo();
                app.addWrittenFile(fInfo);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dataId + " is task " + currentTaskId);
        }
    }

    private void updateParameter(Task task, Parameter p) {
        if (p.isCollective()) {
            CollectiveParameter cParam = (CollectiveParameter)p;
            for (Parameter sp : cParam.getElements()) {
                this.updateParameter(task, sp);
            }
        }
        if (p.isPotentialDependency()) {
            DependencyParameter dp = (DependencyParameter)p;
            EngineDataAccessId dAccId = dp.getDataAccessId();
            int dataId = dAccId.getDataId();
            DataType type = p.getType();
            if (type != DataType.DIRECTORY_T || type != DataType.STREAM_T || type != DataType.EXTERNAL_STREAM_T) {
                DataAccessesInfo dai;
                if (DEBUG) {
                    int currentTaskId = task.getId();
                    LOGGER.debug("Removing writters info for datum " + dataId + " and task " + currentTaskId);
                }
                if ((dai = this.accessesInfo.get(dataId)) != null) {
                    switch (dp.getDirection()) {
                        case OUT: 
                        case INOUT: {
                            dai.completedProducer(task, this.gh);
                            break;
                        }
                    }
                }
            }
            if (DEBUG) {
                LOGGER.debug("Treating that data " + dAccId + " has been accessed at " + dp.getDataTarget());
            }
            if (task.getOnFailure() == OnFailure.CANCEL_SUCCESSORS && task.getStatus() == TaskState.FAILED || task.getStatus() == TaskState.CANCELED) {
                DataInfo.cancelAccess(dAccId, task.wasSubmited());
            } else {
                DataInfo.commitAccess(dAccId);
            }
        }
    }
}

