/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.monitor.impl;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.accesses.DataAccessesInfo;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import java.io.BufferedWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DotGraph
implements GraphHandler {
    private final GraphGenerator gm;
    private int synchronizationId;
    private boolean taskDetectedAfterSync;

    public DotGraph(String graphDir) {
        this.gm = new GraphGenerator(graphDir);
        this.synchronizationId = 0;
        this.gm.addSynchroToGraph(0);
        this.taskDetectedAfterSync = false;
    }

    @Override
    public void openTaskGroup(String groupName) {
        this.gm.addTaskGroupToGraph(groupName);
    }

    @Override
    public void closeTaskGroup() {
        this.gm.closeGroupInGraph();
    }

    @Override
    public void closeCommutativeTasksGroup(CommutativeGroupTask group) {
        this.gm.closeCommutativeGroup(group.getCommutativeIdentifier().toString());
    }

    @Override
    public void startTaskAnalysis(Task task) {
        task.setSynchronizationId(this.synchronizationId);
        this.taskDetectedAfterSync = true;
        this.gm.addTaskToGraph(task);
    }

    @Override
    public void taskBelongsToCommutativeGroup(Task task, CommutativeGroupTask group) {
        this.gm.addTaskToCommutativeGroup(task, group.getCommutativeIdentifier().toString());
    }

    @Override
    public void startGroupingEdges() {
        this.gm.startGroupingEdges();
    }

    @Override
    public void stopGroupingEdges() {
        this.gm.stopGroupingEdges();
    }

    @Override
    public void addStandandDependency(Task consumer, EngineDataAccessId daId, AbstractTask producer) {
        int dataId = daId.getDataId();
        int dataVersion = daId.isRead() ? ((EngineDataAccessId.ReadingDataAccessId)daId).getRVersionId() : ((EngineDataAccessId.WritingDataAccessId)daId).getWVersionId();
        if (producer != null && producer != consumer) {
            if (producer instanceof Task) {
                this.addDataEdgeFromTaskToTask((Task)producer, consumer, dataId, dataVersion);
            } else {
                this.addEdgeFromCommutativeToTask(consumer, dataId, dataVersion, (CommutativeGroupTask)producer, true);
            }
        } else {
            this.addDataEdgeFromMainToTask(consumer, dataId, dataVersion);
        }
    }

    private void addDataEdgeFromTaskToTask(Task source, Task dest, int dataId, int dataVersion) {
        String src = source.getSynchronizationId() == dest.getSynchronizationId() ? String.valueOf(source.getId()) : "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = dataId + "v" + dataVersion;
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    private void addDataEdgeFromMainToTask(Task dest, int dataId, int dataVersion) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = dataId + "v" + dataVersion;
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    private void addEdgeFromCommutativeToTask(Task dest, int dataId, int dataVersion, CommutativeGroupTask cgt, boolean comToTask) {
        String src = String.valueOf(cgt.getCommutativeTasks().get(0).getId());
        String dst = String.valueOf(dest.getId());
        String dep = dataId + "v" + dataVersion;
        String comId = cgt.getCommutativeIdentifier().toString();
        if (comToTask) {
            this.gm.addEdgeToGraphFromGroup(src, dst, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        } else {
            this.gm.addEdgeToGraphFromGroup(dst, src, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        }
    }

    @Override
    public void addStreamDependency(AbstractTask task, Integer streamDataId, boolean isWrite) {
        String stream = "Stream" + streamDataId;
        this.gm.addStreamToGraph(stream);
        String taskId = String.valueOf(task.getId());
        if (isWrite) {
            this.gm.addEdgeToGraph(taskId, stream, EdgeType.STREAM_DEPENDENCY, "");
        } else {
            this.gm.addEdgeToGraph(stream, taskId, EdgeType.STREAM_DEPENDENCY, "");
        }
    }

    @Override
    public void endTaskAnalysis(Task task, boolean taskHasEdge) {
        if (!taskHasEdge) {
            String src = "Synchro" + task.getSynchronizationId();
            String dst = String.valueOf(task.getId());
            String dep = "";
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        }
    }

    @Override
    public void endApp() {
        this.gm.closeCommutativeGroups();
        this.gm.commitGraph(true);
    }

    @Override
    public void mainAccessToData(AbstractTask task, EdgeType edgeType, EngineDataInstanceId accessedData) {
        String newSynch = this.addSynchro(false);
        int dataId = accessedData.getDataId();
        int dataVersion = accessedData.getVersionId();
        String label = dataId + "v" + dataVersion;
        if (task instanceof CommutativeGroupTask && !((CommutativeGroupTask)task).getCommutativeTasks().isEmpty()) {
            CommutativeGroupTask commGroupTask = (CommutativeGroupTask)task;
            String src = String.valueOf(commGroupTask.getCommutativeTasks().get(0).getId());
            String groupId = commGroupTask.getCommutativeIdentifier().toString();
            this.gm.addEdgeToGraphFromGroup(src, newSynch, label, groupId, "clusterCommutative", edgeType);
        } else {
            String src = String.valueOf(task.getId());
            this.gm.addEdgeToGraph(src, newSynch, edgeType, label);
        }
    }

    @Override
    public void groupBarrier(BarrierGroupRequest barrier) {
        this.gm.closeCommutativeGroups();
        String newSyncStr = this.addSynchro(true);
        int groupsLastTaskID = barrier.getGraphSource();
        if (groupsLastTaskID > 0) {
            String src = String.valueOf(groupsLastTaskID);
            String groupName = barrier.getGroupName();
            this.gm.addEdgeToGraphFromGroup(src, newSyncStr, "", groupName, "clusterTasks", EdgeType.USER_DEPENDENCY);
        }
        this.gm.commitGraph(false);
    }

    @Override
    public void barrier(Map<Integer, DataAccessesInfo> accessesInfo) {
        this.gm.closeCommutativeGroups();
        int oldSync = this.synchronizationId;
        String newSyncStr = this.addSynchro(true);
        HashSet<AbstractTask> uniqueWriters = new HashSet<AbstractTask>();
        for (DataAccessesInfo dai : accessesInfo.values()) {
            if (dai == null) continue;
            List<AbstractTask> dataWriters = dai.getDataWriters();
            uniqueWriters.addAll(dataWriters);
        }
        for (AbstractTask writer : uniqueWriters) {
            if (writer == null || writer.getSynchronizationId() != oldSync) continue;
            String taskId = String.valueOf(writer.getId());
            this.gm.addEdgeToGraph(taskId, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        }
        this.gm.commitGraph(false);
    }

    private String addSynchro(boolean barrier) {
        String newSyncStr;
        int oldSync = this.synchronizationId;
        String oldSyncStr = "Synchro" + oldSync;
        if (this.taskDetectedAfterSync || barrier) {
            EdgeType eType;
            ++this.synchronizationId;
            newSyncStr = "Synchro" + this.synchronizationId;
            if (barrier) {
                this.gm.addBarrierToGraph(this.synchronizationId);
                eType = EdgeType.USER_DEPENDENCY;
            } else {
                this.gm.addSynchroToGraph(this.synchronizationId);
                eType = EdgeType.DATA_DEPENDENCY;
            }
            this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, eType, "");
            this.taskDetectedAfterSync = false;
        } else {
            newSyncStr = oldSyncStr;
        }
        return newSyncStr;
    }

    @Override
    public BufferedWriter getAndOpenCurrentGraph() {
        return this.gm.getAndOpenCurrentGraph();
    }

    @Override
    public void closeCurrentGraph() {
        this.gm.closeCurrentGraph();
    }

    @Override
    public void removeCurrentGraph() {
        this.gm.removeTemporaryGraph();
    }
}

