/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.scheduler.types.ActionGroup;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.CommutativeIdentifier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.parameter.impl.Parameter;
import java.util.LinkedList;
import java.util.List;

public class CommutativeGroupTask
extends AbstractTask {
    private static int commGroupTaskId = -1;
    private final CommutativeIdentifier comId;
    private final EngineDataAccessId accessPlaceholder = new CommutativeDataAccessId();
    private final List<Task> commutativeTasks = new LinkedList<Task>();
    private boolean closed = false;
    private AbstractTask groupPredecessor;
    private RWAccessId groupPredecessorAccess;
    private RWAccessId firstAccess = null;
    private LinkedList<RWAccessId> accesses = new LinkedList();
    private final ActionGroup.MutexGroup actions;

    public CommutativeGroupTask(Application app, CommutativeIdentifier comId) {
        super(app, commGroupTaskId--);
        this.comId = comId;
        this.actions = new ActionGroup.MutexGroup();
    }

    public CommutativeIdentifier getCommutativeIdentifier() {
        return this.comId;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    public List<Task> getCommutativeTasks() {
        return this.commutativeTasks;
    }

    public void addCommutativeTask(Task task) {
        this.commutativeTasks.add(task);
    }

    public void setGroupPredecessor(AbstractTask predecessor, RWAccessId access) {
        this.groupPredecessor = predecessor;
        this.groupPredecessorAccess = access;
    }

    public AbstractTask getGroupPredecessor() {
        return this.groupPredecessor;
    }

    public EngineDataAccessId getGroupPredecessorAccess() {
        return this.groupPredecessorAccess;
    }

    public synchronized void addAccess(RWAccessId access) {
        if (this.firstAccess == null) {
            this.firstAccess = access;
        } else {
            this.accesses.add(access);
        }
    }

    public void removePredecessor(Task t) {
        super.getPredecessors().remove(t);
    }

    public EngineDataAccessId getAccessPlaceHolder() {
        return this.accessPlaceholder;
    }

    public synchronized EngineDataAccessId nextAccess() {
        RWAccessId oldAccess = this.firstAccess;
        this.firstAccess = !this.accesses.isEmpty() ? this.accesses.remove() : null;
        return oldAccess;
    }

    public final ActionGroup.MutexGroup getActions() {
        return this.actions;
    }

    @Override
    public List<Parameter> getParameterDataToRemove() {
        return new LinkedList<Parameter>();
    }

    @Override
    public List<Parameter> getIntermediateParameters() {
        return new LinkedList<Parameter>();
    }

    @Override
    public List<Parameter> getUnusedIntermediateParameters() {
        return new LinkedList<Parameter>();
    }

    @Override
    public boolean isReduction() {
        return false;
    }

    @Override
    public String getDotDescription() {
        return null;
    }

    @Override
    public String getLegendDescription() {
        return null;
    }

    @Override
    public String getColor() {
        return null;
    }

    private class CommutativeDataAccessId
    extends RWAccessId {
        private CommutativeDataAccessId() {
        }

        @Override
        public int getDataId() {
            return CommutativeGroupTask.this.firstAccess.getDataId();
        }

        @Override
        public DataAccessId.Direction getDirection() {
            return CommutativeGroupTask.this.firstAccess.getDirection();
        }

        @Override
        public boolean isPreserveSourceData() {
            return CommutativeGroupTask.this.firstAccess.isPreserveSourceData();
        }

        @Override
        public boolean isWrite() {
            return CommutativeGroupTask.this.firstAccess.isWrite();
        }

        @Override
        public EngineDataInstanceId getReadDataInstance() {
            return CommutativeGroupTask.this.firstAccess.getReadDataInstance();
        }

        @Override
        public EngineDataInstanceId getWrittenDataInstance() {
            return CommutativeGroupTask.this.firstAccess.getWrittenDataInstance();
        }

        @Override
        public int getRVersionId() {
            return CommutativeGroupTask.this.firstAccess.getRVersionId();
        }

        @Override
        public int getWVersionId() {
            return CommutativeGroupTask.this.firstAccess.getWVersionId();
        }

        @Override
        public String toString() {
            return "CommutativeAccessId-->" + CommutativeGroupTask.this.firstAccess.toString();
        }
    }
}

