/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.access;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.access.ObjectMainAccess;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessparams.BindingObjectAccessParams;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.operation.BindingObjectTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.data.params.BindingObjectData;
import es.bsc.compss.util.ErrorManager;
import java.util.concurrent.Semaphore;

public class BindingObjectMainAccess
extends ObjectMainAccess<BindingObject, BindingObjectData, BindingObjectAccessParams> {
    public static final BindingObjectMainAccess constructBOMA(Application app, Direction dir, BindingObject bo, int hashCode) {
        BindingObjectAccessParams boap = BindingObjectAccessParams.constructBOAP(app, dir, bo, hashCode);
        return new BindingObjectMainAccess(boap);
    }

    protected BindingObjectMainAccess(BindingObjectAccessParams params) {
        super(params);
    }

    @Override
    public BindingObject fetch(EngineDataAccessId daId) {
        LOGGER.debug("[AccessProcessor] Obtaining " + ((BindingObjectAccessParams)this.getParameters()).getDataDescription());
        EngineDataAccessId.ReadingDataAccessId raId = (EngineDataAccessId.ReadingDataAccessId)daId;
        EngineDataInstanceId diId = raId.getReadDataInstance();
        String targetName = diId.getRenaming();
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Requesting getting object " + targetName);
        }
        LogicalData srcData = diId.getData();
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Logical data for binding object is:" + srcData);
        }
        if (srcData == null) {
            ErrorManager.error("Unregistered data " + targetName);
            return null;
        }
        if (DEBUG) {
            LOGGER.debug("Requesting tranfers binding object " + targetName + " to " + Comm.getAppHost().getName());
        }
        BindingObject srcBO = BindingObject.generate(srcData.getURIs().get(0).getPath());
        BindingObject tgtBO = new BindingObject(targetName, srcBO.getType(), srcBO.getElements());
        LogicalData tgtLd = srcData;
        BindingObjectLocation targetLocation = new BindingObjectLocation(Comm.getAppHost(), tgtBO);
        BindingObjectTransferable transfer = new BindingObjectTransferable();
        Semaphore sem = new Semaphore(0);
        Comm.getAppHost().getData(srcData, targetLocation, tgtLd, (Transferable)transfer, (EventListener)new OneOpWithSemListener(sem));
        if (DEBUG) {
            LOGGER.debug(" Setting tgtName " + transfer.getDataTarget() + " in " + Comm.getAppHost().getName());
        }
        sem.acquireUninterruptibly();
        String boStr = transfer.getDataTarget();
        BindingObject bo = BindingObject.generate(boStr);
        return bo;
    }

    @Override
    public boolean isAccessFinishedOnRegistration() {
        return true;
    }
}

