/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AccessParams<D extends DataParams>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected final D data;
    protected final AccessMode mode;

    private static AccessMode getAccessMode(Direction d) {
        AccessMode am = AccessMode.R;
        switch (d) {
            case IN: 
            case IN_DELETE: {
                am = AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessMode.CV;
            }
        }
        return am;
    }

    protected AccessParams(D data, Direction dir) {
        this.data = data;
        this.mode = AccessParams.getAccessMode(dir);
    }

    public final Application getApp() {
        return ((DataParams)this.data).getApp();
    }

    public D getData() {
        return this.data;
    }

    public final AccessMode getMode() {
        return this.mode;
    }

    public DataInfo getDataInfo() {
        return ((DataParams)this.data).getRegisteredData();
    }

    public final String getDataDescription() {
        return ((DataParams)this.data).getDescription();
    }

    public abstract void checkAccessValidity() throws ValueUnawareRuntimeException;

    public final EngineDataAccessId register() {
        DataInfo dInfo = ((DataParams)this.data).getRegisteredData();
        if (dInfo == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to " + this.getDataDescription());
            }
            dInfo = ((DataParams)this.data).register();
            DataVersion dv = dInfo.getCurrentDataVersion();
            this.registerValueForVersion(dv);
        } else if (DEBUG) {
            LOGGER.debug("Another access to " + this.getDataDescription());
        }
        EngineDataAccessId daId = dInfo.willAccess(this.mode);
        this.externalRegister();
        return daId;
    }

    protected abstract void registerValueForVersion(DataVersion var1);

    protected abstract void externalRegister();

    public void finish(EngineDataInstanceId generatedData) {
        DataInfo dInfo;
        if (generatedData != null && this.resultRemainOnMain()) {
            generatedData.getVersion().valueOnMain();
        }
        if ((dInfo = ((DataParams)this.data).getRegisteredData()) == null) {
            LOGGER.warn(this.getDataDescription() + " has not been accessed before");
            return;
        }
        EngineDataAccessId daid = dInfo.getLastAccess(this.mode);
        if (daid == null) {
            LOGGER.warn(this.getDataDescription() + " has not been accessed before");
            return;
        }
        DataInfo.commitAccess(daid);
    }

    public abstract boolean resultRemainOnMain();

    public static enum AccessMode {
        R(true, false),
        W(false, true),
        RW(true, true),
        C(true, false),
        CV(true, true);

        private final boolean read;
        private final boolean write;

        private AccessMode(boolean read, boolean write) {
            this.read = read;
            this.write = write;
        }

        public final boolean isRead() {
            return this.read;
        }

        public boolean isWrite() {
            return this.write;
        }
    }
}

