/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.CollectionData;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;

public class CollectionAccessParams
extends AccessParams<CollectionData> {
    private static final long serialVersionUID = 1L;

    public static final CollectionAccessParams constructCAP(Application app, Direction dir, String collectionId) {
        return new CollectionAccessParams(app, dir, collectionId);
    }

    private CollectionAccessParams(Application app, Direction dir, String collectionId) {
        super(new CollectionData(app, collectionId), dir);
    }

    @Override
    public void checkAccessValidity() throws ValueUnawareRuntimeException {
    }

    @Override
    protected void registerValueForVersion(DataVersion dv) {
        if (this.mode != AccessParams.AccessMode.W) {
            EngineDataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerCollection(renaming, null);
        } else {
            dv.invalidate();
        }
    }

    @Override
    public boolean resultRemainOnMain() {
        return false;
    }

    @Override
    protected void externalRegister() {
    }
}

