/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.params.FileData;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;

public class FileAccessParams<D extends FileData>
extends AccessParams<D> {
    private static final long serialVersionUID = 1L;

    public static final FileAccessParams constructFAP(Application app, Direction dir, DataLocation loc) {
        FileData fd = new FileData(app, loc);
        return new FileAccessParams<FileData>(fd, dir);
    }

    protected FileAccessParams(D data, Direction dir) {
        super(data, dir);
    }

    public final DataLocation getLocation() {
        return ((FileData)this.data).getLocation();
    }

    @Override
    public void checkAccessValidity() throws ValueUnawareRuntimeException {
        boolean alreadyAccessed;
        LOGGER.debug("Check already accessed: " + ((FileData)this.data).getDescription());
        DataInfo dInfo = ((FileData)this.data).getRegisteredData();
        boolean bl = alreadyAccessed = dInfo != null;
        if (!alreadyAccessed) {
            LOGGER.debug(this.getDataDescription() + " accessed before, returning the same location");
            throw new ValueUnawareRuntimeException();
        }
    }

    @Override
    protected void registerValueForVersion(DataVersion dv) {
        if (this.mode != AccessParams.AccessMode.W) {
            EngineDataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerLocation(renaming, this.getLocation());
        } else {
            dv.invalidate();
        }
    }

    @Override
    public boolean resultRemainOnMain() {
        return false;
    }

    @Override
    protected void externalRegister() {
    }

    public String toString() {
        return "[" + this.getApp() + ", " + (Object)((Object)this.mode) + " ," + this.getLocation() + "]";
    }
}

