/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.info;

import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.NonExistingValueException;
import es.bsc.compss.util.ErrorManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataInfo<T extends DataParams> {
    private static final int FIRST_FILE_ID = 1;
    private static final int FIRST_VERSION_ID = 1;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final Map<Integer, DataInfo> ID_TO_DATA = new TreeMap<Integer, DataInfo>();
    protected static int nextDataId = 1;
    protected final int dataId = nextDataId++;
    protected final T params;
    protected DataVersion currentVersion;
    protected int currentVersionId;
    protected TreeMap<Integer, DataVersion> versions;
    protected int deletionBlocks;
    protected final LinkedList<DataVersion> pendingDeletions;
    protected final LinkedList<Integer> canceledVersions;
    protected boolean deleted;

    public static void commitAccess(EngineDataAccessId dAccId) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = DataInfo.get(dataId);
        if (di != null) {
            di.committedAccess(dAccId);
        } else {
            LOGGER.warn("Access of Data" + dAccId.getDataId() + " in Mode " + dAccId.getDirection().name() + "can not be mark as accessed because do not exist in DIP.");
        }
    }

    public static void cancelAccess(EngineDataAccessId dAccId, boolean keepModified) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = DataInfo.get(dataId);
        if (di != null) {
            di.cancelledAccess(dAccId, keepModified);
        } else {
            LOGGER.debug("Access of Data" + dAccId.getDataId() + " in Mode " + dAccId.getDirection().name() + " can not be cancelled because do not exist in DIP.");
        }
    }

    public DataInfo(T data) {
        this.params = data;
        this.versions = new TreeMap();
        this.currentVersionId = 1;
        this.currentVersion = new DataVersion(this.dataId, 1, null);
        this.versions.put(this.currentVersionId, this.currentVersion);
        this.deletionBlocks = 0;
        this.pendingDeletions = new LinkedList();
        this.canceledVersions = new LinkedList();
        this.deleted = false;
        ID_TO_DATA.put(this.dataId, this);
    }

    public final int getDataId() {
        return this.dataId;
    }

    public final T getParams() {
        return this.params;
    }

    public final DataVersion getFirstVersion() {
        return this.versions.get(1);
    }

    public final DataVersion getCurrentDataVersion() {
        return this.currentVersion;
    }

    public final EngineDataAccessId getLastAccess(AccessParams.AccessMode mode) {
        EngineDataAccessId daId = null;
        if (this.currentVersion != null) {
            switch (mode) {
                case C: 
                case R: {
                    daId = new RAccessId(this.currentVersion);
                    break;
                }
                case W: {
                    daId = new WAccessId(this.currentVersion);
                    break;
                }
                case CV: 
                case RW: {
                    DataVersion readInstance = this.versions.get(this.currentVersionId - 1);
                    if (readInstance != null) {
                        daId = new RWAccessId(readInstance, this.currentVersion);
                        break;
                    }
                    LOGGER.warn("Previous instance for data" + this.dataId + " is null.");
                }
            }
        } else {
            LOGGER.warn("Current instance for data" + this.dataId + " is null.");
        }
        return daId;
    }

    public final EngineDataAccessId willAccess(AccessParams.AccessMode mode) {
        EngineDataAccessId daId = null;
        switch (mode) {
            case C: 
            case R: {
                this.willBeRead();
                daId = new RAccessId(this.currentVersion);
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: R").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RAccessId)daId).getRVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case W: {
                this.willBeWritten();
                daId = new WAccessId(this.currentVersion);
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: W").append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((WAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case CV: 
            case RW: {
                this.willBeRead();
                DataVersion readInstance = this.currentVersion;
                this.willBeWritten();
                DataVersion writtenInstance = this.currentVersion;
                if (readInstance != null) {
                    daId = new RWAccessId(readInstance, writtenInstance);
                    if (!DEBUG) break;
                    StringBuilder sb = new StringBuilder("");
                    sb.append("Access:").append("\n");
                    sb.append("  * Type: RW").append("\n");
                    sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getRVersionId()).append("\n");
                    sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((RWAccessId)daId).getWVersionId()).append("\n");
                    LOGGER.debug(sb.toString());
                    break;
                }
                ErrorManager.warn("Previous instance for data" + this.dataId + " is null.");
            }
        }
        return daId;
    }

    private void willBeRead() {
        this.currentVersion.versionUsed();
        this.currentVersion.willBeRead();
    }

    protected void willBeWritten() {
        ++this.currentVersionId;
        DataVersion validPred = this.currentVersion;
        if (validPred.hasBeenCancelled()) {
            validPred = validPred.getPreviousValidPredecessor();
        }
        DataVersion newVersion = new DataVersion(this.dataId, this.currentVersionId, validPred);
        newVersion.willBeWritten();
        this.versions.put(this.currentVersionId, newVersion);
        this.currentVersion = newVersion;
        this.currentVersion.versionUsed();
    }

    private void tryRemoveVersion(Integer versionId) {
        DataVersion version = this.versions.get(versionId);
        if (version != null && version.markToDelete()) {
            version.getDataInstanceId().delete();
            this.versions.remove(versionId);
        }
    }

    private void committedAccess(EngineDataAccessId dAccId) {
        Integer rVersionId = null;
        boolean deleted = false;
        if (dAccId.isRead()) {
            rVersionId = ((EngineDataAccessId.ReadingDataAccessId)dAccId).getReadDataInstance().getVersionId();
            deleted = this.versionHasBeenRead(rVersionId);
        }
        if (dAccId.isWrite()) {
            Integer wVersionId = ((EngineDataAccessId.WritingDataAccessId)dAccId).getWrittenDataInstance().getVersionId();
            if (rVersionId == null) {
                rVersionId = wVersionId - 1;
            }
            this.tryRemoveVersion(rVersionId);
            deleted = this.versionHasBeenWritten(wVersionId);
        }
        if (deleted) {
            this.deregister();
        }
    }

    private boolean versionHasBeenRead(int versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (readVersion.hasBeenRead()) {
            readVersion.getDataInstanceId().delete();
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    private boolean versionHasBeenWritten(int versionId) {
        DataVersion writtenVersion = this.versions.get(versionId);
        if (writtenVersion.hasBeenWritten()) {
            writtenVersion.getDataInstanceId().delete();
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    public final boolean isCurrentVersionBeenUsed() {
        return this.currentVersion.hasBeenUsed();
    }

    private void cancelledAccess(EngineDataAccessId dAccId, boolean keepModified) {
        boolean deleted = false;
        switch (dAccId.getDirection()) {
            case C: 
            case R: {
                Integer rVersionId = ((RAccessId)dAccId).getReadDataInstance().getVersionId();
                deleted = this.canceledReadVersion(rVersionId);
                break;
            }
            case CV: 
            case RW: {
                Integer rVersionId = ((RWAccessId)dAccId).getReadDataInstance().getVersionId();
                Integer wVersionId = ((RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                if (keepModified) {
                    this.versionHasBeenRead(rVersionId);
                    this.tryRemoveVersion(rVersionId);
                    deleted = this.versionHasBeenWritten(wVersionId);
                    break;
                }
                this.canceledReadVersion(rVersionId);
                deleted = this.canceledWriteVersion(wVersionId);
                break;
            }
            default: {
                Integer wVersionId = ((WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                deleted = this.canceledWriteVersion(wVersionId);
            }
        }
        if (deleted) {
            this.deregister();
        }
    }

    private boolean canceledReadVersion(Integer versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (!this.deleted && readVersion.isToDelete() && readVersion.hasBeenUsed()) {
            readVersion.unmarkToDelete();
        }
        if (readVersion.hasBeenRead()) {
            readVersion.getDataInstanceId().delete();
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    private boolean canceledWriteVersion(Integer versionId) {
        DataVersion version = this.versions.get(versionId);
        version.versionCancelled();
        this.canceledVersions.add(versionId);
        if (versionId == this.currentVersionId) {
            Integer lastVersion = this.currentVersionId;
            while (this.canceledVersions.contains(lastVersion)) {
                this.tryRemoveVersion(lastVersion);
                lastVersion = lastVersion - 1;
            }
            if (lastVersion > 1) {
                this.currentVersionId = lastVersion;
                this.currentVersion = this.versions.get(this.currentVersionId);
                return false;
            }
            if (lastVersion == 1) {
                DataVersion firstVersion = this.getFirstVersion();
                if (firstVersion != null && firstVersion.hasBeenUsed()) {
                    this.currentVersionId = lastVersion;
                    this.currentVersion = firstVersion;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private void deregister() {
        ID_TO_DATA.remove(this.dataId);
    }

    private static DataInfo get(Integer dataId) {
        return ID_TO_DATA.get(dataId);
    }

    public final void blockDeletions() {
        ++this.deletionBlocks;
    }

    public final boolean unblockDeletions() {
        --this.deletionBlocks;
        if (this.deletionBlocks == 0) {
            for (DataVersion version : this.pendingDeletions) {
                if (!version.markToDelete()) continue;
                version.getDataInstanceId().delete();
                this.versions.remove(version.getDataInstanceId().getVersionId());
            }
            if (this.versions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void delete() {
        this.deleted = true;
        if (this.deletionBlocks > 0) {
            this.pendingDeletions.addAll(this.versions.values());
        } else {
            LinkedList<Integer> removedVersions = new LinkedList<Integer>();
            for (DataVersion version : this.versions.values()) {
                if (!version.markToDelete()) continue;
                version.getDataInstanceId().delete();
                removedVersions.add(version.getDataInstanceId().getVersionId());
            }
            Iterator<DataVersion> iterator = removedVersions.iterator();
            while (iterator.hasNext()) {
                int versionId = (Integer)((Object)iterator.next());
                this.versions.remove(versionId);
            }
            if (this.versions.isEmpty()) {
                this.deregister();
            }
        }
    }

    public abstract void waitForDataReadyToDelete(Semaphore var1) throws NonExistingValueException;

    public final boolean isCurrentVersionToDelete() {
        return this.currentVersion.isToDelete();
    }
}

