/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.info;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.data.params.FileData;
import es.bsc.compss.types.request.exceptions.NonExistingValueException;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.FileOpsManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileInfo
extends DataInfo<FileData> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");

    public FileInfo(FileData file) {
        super(file);
    }

    public DataLocation getOriginalLocation() {
        return ((FileData)this.getParams()).getLocation();
    }

    @Override
    public void waitForDataReadyToDelete(Semaphore sem) throws NonExistingValueException {
        LOGGER.debug("[FileInfo] Deleting file of data " + this.getDataId());
        DataVersion firstVersion = this.getFirstVersion();
        if (firstVersion != null && firstVersion.isValid()) {
            LogicalData ld = firstVersion.getDataInstanceId().getData();
            if (ld != null) {
                for (DataLocation loc : ld.getLocations()) {
                    MultiURI uri = loc.getURIInHost(Comm.getAppHost());
                    if (uri == null || !loc.equals(this.getOriginalLocation())) continue;
                    DeletionListener listener = new DeletionListener(sem, firstVersion, loc, uri);
                    if (loc.getType() != LocationType.SHARED) {
                        this.waitForEndingCopies(ld, listener);
                    } else {
                        listener.addPendingOperation();
                        if (!firstVersion.addSemaphore(listener)) {
                            LOGGER.debug("[FileInfo] Readers for first version of " + this.getDataId() + " finished. Nothing to do. Releasing semaphore.");
                            listener.release();
                        }
                    }
                    listener.enable();
                    return;
                }
                throw new NonExistingValueException();
            }
        } else {
            throw new NonExistingValueException();
        }
    }

    private void waitForEndingCopies(LogicalData ld, DeletionListener listener) {
        Collection<Copy> copiesInProgress = ld.getCopiesInProgress();
        if (copiesInProgress != null && !copiesInProgress.isEmpty()) {
            for (Copy copy : copiesInProgress) {
                if (!copy.getSourceData().equals(ld)) continue;
                LOGGER.debug("[FileInfo] Waiting for copy of data " + ld.getName() + " to finish...");
                SafeCopyListener currentCopylistener = new SafeCopyListener(listener);
                listener.addPendingOperation();
                copy.addEventListener(currentCopylistener);
                currentCopylistener.addOperation();
                currentCopylistener.enable();
            }
        }
    }

    private static class DeletionListener
    extends Semaphore {
        private final Semaphore sem;
        private final DataVersion version;
        private final DataLocation loc;
        private final MultiURI uri;
        private int missingOperations = 1;

        public DeletionListener(Semaphore sem, DataVersion version, DataLocation location, MultiURI uri) {
            super(0);
            this.sem = sem;
            this.version = version;
            this.loc = location;
            this.uri = uri;
        }

        public void addPendingOperation() {
            ++this.missingOperations;
        }

        public void enable() {
            --this.missingOperations;
            if (this.missingOperations == 0) {
                this.completed();
            }
        }

        @Override
        public void release() {
            --this.missingOperations;
            if (this.missingOperations == 0) {
                this.completed();
            }
        }

        public void completed() {
            EngineDataInstanceId daId = this.version.getDataInstanceId();
            LogicalData ld = daId.getData();
            if (this.version.hasPendingLectures()) {
                String rename = daId.getRenaming();
                this.moveToWorkingDir(this.loc, this.uri, rename);
            } else {
                ld.removeLocation(this.loc);
            }
            this.sem.release();
        }

        private void moveToWorkingDir(DataLocation loc, MultiURI uri, String renaming) {
            String newPath = Comm.getAppHost().getWorkingDirectory() + File.separator + renaming;
            LOGGER.debug("[FileInfo] Modifying path in location " + loc + " with new path " + newPath);
            loc.modifyPath(newPath);
            try {
                LOGGER.debug("[FileInfo] Moving " + uri.getPath() + " to " + newPath);
                FileOpsManager.moveSync(new File(uri.getPath()), new File(newPath));
            }
            catch (IOException e) {
                ErrorManager.warn("File " + uri.getPath() + " cannot be moved to " + newPath + "Reason: " + e.getMessage());
            }
        }
    }
}

