/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.CollectionInfo;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;

public class CollectionData
extends DataParams {
    private final String collectionId;

    public CollectionData(Application app, String collectionId) {
        super(app);
        this.collectionId = collectionId;
    }

    @Override
    public String getDescription() {
        return "collection  " + this.collectionId;
    }

    @Override
    protected DataInfo registerData() {
        CollectionInfo cInfo = new CollectionInfo(this);
        Application app = this.getApp();
        app.registerCollectionData(this.collectionId, cInfo);
        return cInfo;
    }

    @Override
    public DataInfo getRegisteredData() {
        Application app = this.getApp();
        return app.getCollectionData(this.collectionId);
    }

    @Override
    protected DataInfo unregisterData() throws ValueUnawareRuntimeException {
        Application app = this.getApp();
        return app.removeCollectionData(this.collectionId);
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    @Override
    public void deleteLocal() throws Exception {
    }
}

