/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataParams {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final Application app;

    public DataParams(Application app) {
        this.app = app;
    }

    public Application getApp() {
        return this.app;
    }

    public abstract String getDescription();

    public final DataInfo register() {
        if (DEBUG) {
            LOGGER.debug("Registering Data associated to " + this.getDescription());
        }
        return this.registerData();
    }

    public final DataInfo delete() throws ValueUnawareRuntimeException {
        if (DEBUG) {
            LOGGER.debug("Deleting Data associated to " + this.getDescription());
        }
        try {
            return this.unregisterData();
        }
        catch (ValueUnawareRuntimeException vure) {
            if (DEBUG) {
                LOGGER.debug("No data found for data associated to " + this.getDescription());
            }
            throw vure;
        }
    }

    protected abstract DataInfo registerData();

    public abstract DataInfo getRegisteredData();

    protected abstract DataInfo unregisterData() throws ValueUnawareRuntimeException;

    public abstract void deleteLocal() throws Exception;
}

