/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.FileInfo;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.util.FileOpsManager;
import java.io.File;

public class FileData
extends DataParams {
    protected final String locKey;
    private final DataLocation loc;

    public FileData(Application app, DataLocation loc) {
        super(app);
        this.loc = loc;
        this.locKey = loc.getLocationKey();
    }

    @Override
    public String getDescription() {
        return "file " + this.locKey;
    }

    @Override
    protected DataInfo registerData() {
        Application app = this.getApp();
        FileInfo dInfo = new FileInfo(this);
        app.registerFileData(this.locKey, dInfo);
        return dInfo;
    }

    @Override
    public DataInfo getRegisteredData() {
        Application app = this.getApp();
        String locationKey = this.loc.getLocationKey();
        return app.getFileData(locationKey);
    }

    @Override
    protected DataInfo unregisterData() throws ValueUnawareRuntimeException {
        Application app = this.getApp();
        String locationKey = this.loc.getLocationKey();
        return app.removeFileData(locationKey);
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    @Override
    public void deleteLocal() throws Exception {
        String filePath = this.getLocation().getURIInHost(Comm.getAppHost()).getPath();
        File f = new File(filePath);
        FileOpsManager.deleteSync(f);
    }
}

