/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.ObjectInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;

public class ObjectData
extends DataParams {
    protected final int code;

    public ObjectData(Application app, int code) {
        super(app);
        this.code = code;
    }

    @Override
    public String getDescription() {
        return "object with code " + this.code;
    }

    @Override
    protected DataInfo registerData() {
        ObjectInfo oInfo = new ObjectInfo(this);
        Application app = this.getApp();
        app.registerObjectData(this.code, oInfo);
        return oInfo;
    }

    @Override
    public DataInfo getRegisteredData() {
        Application app = this.getApp();
        return app.getObjectData(this.code);
    }

    @Override
    protected DataInfo unregisterData() throws ValueUnawareRuntimeException {
        Application app = this.getApp();
        return app.removeObjectData(this.code);
    }

    public final int getCode() {
        return this.code;
    }

    @Override
    public void deleteLocal() throws Exception {
    }
}

