/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.listeners;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.listeners.ResourceCreationListener;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.ResourceManager;

public class CancelTaskGroupOnResourceCreation
implements ResourceCreationListener {
    private final AccessProcessor ap;
    private final Application application;
    private final int numTotalResources;
    private int grantedResources;
    private final String taskGroupName;

    public CancelTaskGroupOnResourceCreation(AccessProcessor ap, Application application, int numTotalResources, String taskGroupName) {
        this.ap = ap;
        this.application = application;
        this.numTotalResources = numTotalResources;
        this.grantedResources = 0;
        this.taskGroupName = taskGroupName;
    }

    @Override
    public void notifyResourceCreation(ResourceDescription desc) {
        ++this.grantedResources;
        if (this.grantedResources < this.numTotalResources) {
            ResourceManager.requestResources(1, this);
        } else if (this.ap != null && this.application != null && this.taskGroupName != null && !this.taskGroupName.isEmpty() && !this.taskGroupName.equals("NULL")) {
            this.ap.cancelTaskGroup(this.application, this.taskGroupName);
        }
    }
}

