/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.parameter.impl;

import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.accessparams.BindingObjectAccessParams;
import es.bsc.compss.types.data.params.BindingObjectData;
import es.bsc.compss.types.parameter.impl.ObjectParameter;

public class BindingObjectParameter
extends ObjectParameter<BindingObject, BindingObjectAccessParams, BindingObjectData> {
    private static final long serialVersionUID = 1L;

    public static final BindingObjectParameter newBOP(Application app, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, BindingObject bo, int hashCode, ParameterMonitor monitor) {
        BindingObjectAccessParams boap = BindingObjectAccessParams.constructBOAP(app, direction, bo, hashCode);
        return new BindingObjectParameter(boap, direction, stream, prefix, name, contentType, weight, monitor);
    }

    private BindingObjectParameter(BindingObjectAccessParams boap, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, ParameterMonitor monitor) {
        super(boap, DataType.BINDING_OBJECT_T, direction, stream, prefix, name, contentType, weight, monitor);
    }

    public String getId() {
        return ((BindingObjectAccessParams)this.getAccess()).getBindingObject().toString();
    }

    @Override
    public String getOriginalName() {
        return ((BindingObjectAccessParams)this.getAccess()).getBindingObject().getId();
    }

    @Override
    public String toString() {
        BindingObject bo = this.getBindingObject();
        return "BindingObjectParameter with Id " + bo.getId() + ", type " + bo.getType() + ", elements " + bo.getElements() + " and HashCode " + this.getCode();
    }

    @Override
    public String getDataTarget() {
        BindingObject bo = this.getBindingObject();
        String dataTarget = super.getDataTarget();
        if (dataTarget != null) {
            if (dataTarget.contains("#")) {
                return dataTarget;
            }
            return dataTarget + "#" + bo.getType() + "#" + bo.getElements();
        }
        return "null#" + bo.getType() + "#" + bo.getElements();
    }

    public BindingObject getBindingObject() {
        return ((BindingObjectAccessParams)this.getAccess()).getBindingObject();
    }

    @Override
    public String generateDataTargetName(String tgtName) {
        BindingObject bo = this.getBindingObject();
        if (!tgtName.contains("#")) {
            tgtName = tgtName + "#" + bo.getType() + "#" + bo.getElements();
        }
        return tgtName;
    }
}

