/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.listener.StaticMultioperationSemaphore;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.worker.COMPSsException;
import java.util.List;
import java.util.concurrent.Semaphore;

public class CancelTaskGroupRequest
extends APRequest {
    private final Application app;
    private final String groupName;
    private final Semaphore sem;

    public CancelTaskGroupRequest(Application app, String groupName, Semaphore sem) {
        this.app = app;
        this.groupName = groupName;
        this.sem = sem;
    }

    public final Semaphore getSemaphore() {
        return this.sem;
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.CANCEL_TASK_GROUP;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, TaskDispatcher td) throws ShutdownException, COMPSsException {
        LOGGER.debug("Cancelling tasks of group " + this.groupName);
        this.cancelGroup(ta, td);
    }

    protected final void cancelGroup(TaskAnalyser ta, TaskDispatcher td) {
        TaskGroup tg = this.app.removeGroup(this.groupName);
        if (tg != null) {
            List<Task> tasks = tg.getTasks();
            int taskCount = tasks.size();
            StaticMultioperationSemaphore listener = new StaticMultioperationSemaphore(taskCount, this.sem);
            LOGGER.debug("Cancelling " + taskCount + " tasks.");
            for (Task t : tasks) {
                td.cancelTasks(t, listener);
            }
        } else {
            this.sem.release();
        }
    }

    public Application getApp() {
        return this.app;
    }

    public final String getGroupName() {
        return this.groupName;
    }
}

