/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.info.FileInfo;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DirectoryTransferable;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Semaphore;
import storage.StorageException;
import storage.StorageItf;

public class GetResultFilesRequest
extends APRequest {
    private static final String RES_FILE_TRANSFER_ERR = "Error transferring result files";
    private final Application app;
    private final Semaphore sem;
    private final LinkedList<ResultFile> blockedData;

    public GetResultFilesRequest(Application app, Semaphore sem) {
        this.app = app;
        this.sem = sem;
        this.blockedData = new LinkedList();
    }

    public Application getApp() {
        return this.app;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public LinkedList<ResultFile> getBlockedData() {
        return this.blockedData;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, TaskDispatcher td) {
        ResultListener listener = new ResultListener(this.sem);
        Set<FileInfo> writtenData = this.app.getWrittenFiles();
        if (writtenData != null) {
            for (FileInfo fInfo : writtenData) {
                ResultFile rf = this.blockResultFile(fInfo);
                if (rf == null) continue;
                this.fetchResult(rf, listener);
                this.blockedData.add(rf);
            }
            listener.enable();
        } else {
            this.sem.release();
        }
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.BLOCK_AND_GET_RESULT_FILES;
    }

    private ResultFile blockResultFile(FileInfo fInfo) {
        if (DEBUG) {
            int dataId = fInfo.getDataId();
            LOGGER.debug("Get Result file for data " + dataId);
        }
        if (fInfo.isCurrentVersionBeenUsed()) {
            if (!fInfo.isCurrentVersionToDelete()) {
                String[] splitPath = fInfo.getOriginalLocation().getPath().split(File.separator);
                String origName = splitPath[splitPath.length - 1];
                if (origName.startsWith("compss-serialized-obj_")) {
                    if (DEBUG) {
                        LOGGER.debug("Discarding file " + origName + " as a result");
                    }
                    return null;
                }
                fInfo.blockDeletions();
                EngineDataInstanceId lastVersion = fInfo.getCurrentDataVersion().getDataInstanceId();
                String renaming = lastVersion.getRenaming();
                while (renaming != null && !Comm.existsData(renaming)) {
                    renaming = EngineDataInstanceId.previousVersionRenaming(renaming);
                }
                if (renaming == null) {
                    LOGGER.error("Error transferring result files: Cannot transfer file " + lastVersion.getRenaming() + " nor any of its previous versions");
                    return null;
                }
                LogicalData data = Comm.getData(renaming);
                return new ResultFile(fInfo, data);
            }
            if (fInfo.isCurrentVersionToDelete()) {
                if (DEBUG) {
                    String[] splitPath = fInfo.getOriginalLocation().getPath().split(File.separator);
                    String origName = splitPath[splitPath.length - 1];
                    LOGGER.debug("Trying to delete file " + origName);
                }
                fInfo.delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchResult(ResultFile rf, ResultListener listener) {
        LogicalData data = rf.getData();
        for (DataLocation loc : data.getLocations()) {
            if (!(loc instanceof PersistentLocation)) continue;
            String pscoId = ((PersistentLocation)loc).getId();
            if (Tracer.isActivated()) {
                Tracer.emitEvent(TraceEvent.STORAGE_CONSOLIDATE);
            }
            try {
                StorageItf.consolidateVersion(pscoId);
            }
            catch (StorageException e) {
                LOGGER.error("Cannot consolidate PSCO " + pscoId, (Throwable)e);
            }
            finally {
                if (Tracer.isActivated()) {
                    Tracer.emitEventEnd(TraceEvent.STORAGE_CONSOLIDATE);
                }
            }
            LOGGER.debug("Returned because persistent object");
            return;
        }
        if (rf.getOriginalLocation().getProtocol() == ProtocolType.BINDING_URI) {
            if (DEBUG) {
                int dataId = rf.getFileInfo().getDataId();
                LOGGER.debug("Discarding data d" + dataId + " as a result because it is a binding object");
            }
        } else {
            DataLocation origLoc = rf.getOriginalLocation();
            if (origLoc.getProtocol() == ProtocolType.DIR_URI) {
                listener.addOperation();
                Comm.getAppHost().getData(data, origLoc, (Transferable)new DirectoryTransferable(), (EventListener)listener);
            } else {
                listener.addOperation();
                Comm.getAppHost().getData(data, origLoc, (Transferable)new FileTransferable(), (EventListener)listener);
            }
        }
    }
}

