/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.ErrorManager;

public class RegisterRemoteDataRequest
extends APRequest {
    private final DataParams accessedValue;
    private final String data;

    public RegisterRemoteDataRequest(DataParams accessedValue, String data) {
        this.accessedValue = accessedValue;
        this.data = data;
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.REGISTER_REMOTE_DATA;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, TaskDispatcher td) throws ShutdownException {
        DataInfo dInfo = this.accessedValue.getRegisteredData();
        if (dInfo == null) {
            if (DEBUG) {
                LOGGER.debug("Registering Remote data on DIP: " + this.accessedValue.getDescription());
            }
            dInfo = this.accessedValue.register();
        }
        if (this.data != null && dInfo != null) {
            String existingRename = dInfo.getCurrentDataVersion().getDataInstanceId().getRenaming();
            try {
                Comm.linkData(this.data, existingRename);
            }
            catch (CommException ce) {
                ErrorManager.error("Could not link the newly created data for " + this.accessedValue.getDescription() + " with data " + this.data, ce);
            }
        }
    }
}

