/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.info;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CommutativeIdentifier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.DataOwner;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class StandardDataInfo<T extends DataParams>
extends DataInfo<T> {
    private AbstractTask lastWriter;
    private final List<Task> concurrentReaders = new ArrayList<Task>();

    public StandardDataInfo(T data, DataOwner owner) {
        super(data, owner);
    }

    @Override
    public final EngineDataAccessId willAccess(AccessParams.AccessMode mode) {
        EngineDataAccessId daId = null;
        switch (mode) {
            case C: 
            case R: {
                this.currentVersionWillBeRead();
                daId = new RAccessId(this, this.currentVersion);
                break;
            }
            case W: {
                this.newVersion();
                this.currentVersionWillBeWritten();
                daId = new WAccessId(this, this.currentVersion);
                break;
            }
            case CV: 
            case RW: {
                this.currentVersionWillBeRead();
                DataVersion readInstance = this.currentVersion;
                this.newVersion();
                this.currentVersionWillBeWritten();
                DataVersion writtenInstance = this.currentVersion;
                if (readInstance != null) {
                    daId = new RWAccessId(this, readInstance, writtenInstance);
                    break;
                }
                ErrorManager.warn("Previous instance for data" + this.dataId + " is null.");
            }
        }
        if (DEBUG && daId != null) {
            LOGGER.debug(daId.toDebugString());
        }
        return daId;
    }

    @Override
    public void completedProducer(AbstractTask task) {
        int producerTaskId = task.getId();
        if (this.lastWriter != null && this.lastWriter.getId() == producerTaskId) {
            this.updateLastWriter(null);
        }
    }

    @Override
    public AbstractTask getLastVersionProducer() {
        return this.lastWriter;
    }

    @Override
    public boolean readValue(Task task, DependencyParameter dp, boolean isConcurrent) {
        if (this.concurrentReaders.isEmpty() || isConcurrent) {
            return this.readDependency(task, dp);
        }
        return this.dependsFromConcurrent(task, dp);
    }

    private boolean readDependency(Task task, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        boolean hasEdge = false;
        if (this.lastWriter != null && this.lastWriter != task) {
            if (DEBUG) {
                LOGGER.debug("Last writer for datum " + dataId + " is task " + this.lastWriter.getId());
                LOGGER.debug("Adding dependency between task " + this.lastWriter.getId() + " and task " + task.getId());
            }
            Application app = task.getApplication();
            if (this.lastWriter instanceof CommutativeGroupTask) {
                CommutativeGroupTask group = (CommutativeGroupTask)this.lastWriter;
                if (dp.getDirection() == Direction.COMMUTATIVE && !group.isClosed()) {
                    Integer coreId = task.getTaskDescription().getCoreElement().getCoreId();
                    CommutativeIdentifier comId = new CommutativeIdentifier(coreId, dataId);
                    if (CommutativeIdentifier.equals(group.getCommutativeIdentifier(), comId)) {
                        AbstractTask predecessor = group.getGroupPredecessor();
                        if (predecessor != null) {
                            task.addDataDependency(predecessor, dp);
                            app.getGH().addStandandDependency(task, group.getGroupPredecessorAccess(), predecessor);
                            hasEdge = true;
                        }
                        return hasEdge;
                    }
                }
                group.close();
            }
            task.addDataDependency(this.lastWriter, dp);
            app.getGH().addStandandDependency(task, dp.getDataAccessId(), this.lastWriter);
            hasEdge = true;
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            task.registerFreeParam(dp);
        }
        return hasEdge;
    }

    private boolean dependsFromConcurrent(Task task, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        if (!this.concurrentReaders.contains(task)) {
            if (DEBUG) {
                LOGGER.debug("There was a concurrent access for datum " + dataId);
                LOGGER.debug("Adding dependency between concurrent list and task " + task.getId());
            }
            for (AbstractTask abstractTask : this.concurrentReaders) {
                task.addDataDependency(abstractTask, dp);
                Application app = task.getApplication();
                app.getGH().addStandandDependency(task, dp.getDataAccessId(), abstractTask);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            task.registerFreeParam(dp);
        }
        return true;
    }

    @Override
    public void writeValue(Task t, DependencyParameter dp, boolean isConcurrent) {
        if (isConcurrent) {
            this.concurrentReaders.add(t);
        } else {
            int dataId = dp.getDataAccessId().getDataId();
            LOGGER.info("Setting writer for data " + dataId);
            if (dp.getDirection() == Direction.COMMUTATIVE) {
                CommutativeGroupTask prevGroup;
                Integer coreId = t.getTaskDescription().getCoreElement().getCoreId();
                CommutativeIdentifier comId = new CommutativeIdentifier(coreId, dataId);
                CommutativeGroupTask group = null;
                if (this.lastWriter instanceof CommutativeGroupTask && CommutativeIdentifier.equals((prevGroup = (CommutativeGroupTask)this.lastWriter).getCommutativeIdentifier(), comId) && !prevGroup.isClosed()) {
                    group = prevGroup;
                }
                EngineDataAccessId daId = dp.getDataAccessId();
                if (group == null) {
                    Application app = t.getApplication();
                    group = new CommutativeGroupTask(app, comId);
                    group.setGroupPredecessor(this.lastWriter, (RWAccessId)daId);
                }
                group.addAccess((RWAccessId)daId);
                group.addCommutativeTask(t);
                group.addDataDependency(t, dp);
                t.setCommutativeGroup(group, daId);
                dp.setDataAccessId(group.getAccessPlaceHolder());
                this.updateLastWriter(group);
            } else {
                this.updateLastWriter(t);
            }
            this.concurrentReaders.clear();
        }
    }

    private void updateLastWriter(AbstractTask newWriter) {
        if (this.lastWriter != newWriter && this.lastWriter instanceof CommutativeGroupTask) {
            CommutativeGroupTask prevGroup = (CommutativeGroupTask)this.lastWriter;
            prevGroup.close();
        }
        this.lastWriter = newWriter;
    }

    @Override
    public void mainAccess(RegisterDataAccessRequest rdar, EngineDataAccessId access) {
        EngineDataInstanceId accessedData = access.isWrite() ? ((EngineDataAccessId.WritingDataAccessId)((Object)access)).getWrittenDataInstance() : ((EngineDataAccessId.ReadingDataAccessId)((Object)access)).getReadDataInstance();
        Application app = rdar.getAccess().getApp();
        if (this.lastWriter != null) {
            app.getGH().mainAccessToData(this.lastWriter, EdgeType.DATA_DEPENDENCY, accessedData);
            this.lastWriter.addListener(rdar);
            rdar.addPendingOperation();
        }
        for (AbstractTask abstractTask : this.concurrentReaders) {
            app.getGH().mainAccessToData(abstractTask, EdgeType.DATA_DEPENDENCY, accessedData);
            abstractTask.addListener(rdar);
            rdar.addPendingOperation();
        }
        this.concurrentReaders.clear();
        if (((AccessParams)rdar.getAccess().getParameters()).getMode().isWrite()) {
            this.updateLastWriter(null);
        }
    }

    @Override
    public List<AbstractTask> getDataWriters() {
        LinkedList<AbstractTask> writers = new LinkedList<AbstractTask>();
        if (this.lastWriter != null) {
            writers.add(this.lastWriter);
        }
        return writers;
    }
}

