/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import es.bsc.compss.scheduler.types.AllocatableAction;
import java.util.HashSet;
import java.util.Set;

public class ActionGroup {
    private final Set<AllocatableAction> actions = new HashSet<AllocatableAction>();

    public final void addMember(AllocatableAction newMember) {
        this.actions.add(newMember);
    }

    public final void removeMember(AllocatableAction member) {
        this.actions.remove(member);
    }

    public final Iterable<AllocatableAction> getMembers() {
        return this.actions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ActionGroup@").append(this.hashCode());
        for (AllocatableAction action : this.getMembers()) {
            sb.append(action.toString());
        }
        return sb.toString();
    }

    public static class MutexGroup
    extends ActionGroup {
        private AllocatableAction lockHolder = null;

        public boolean testLock(AllocatableAction action) {
            return this.lockHolder == null || this.lockHolder == action;
        }

        public void acquireLock(AllocatableAction action) {
            this.lockHolder = action;
        }

        public void releaseLock() {
            this.lockHolder = null;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("MutexGroup@").append(this.hashCode()).append("[");
            for (AllocatableAction action : this.getMembers()) {
                sb.append(" ").append(action == this.lockHolder ? "-" + action.toString() + "-" : action.toString());
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

