/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionGroup;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.impl.DependencyParameter;
import es.bsc.compss.types.parameter.impl.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExecutionAction
extends AllocatableAction
implements JobListener<Parameter> {
    private static final int SCHEDULING_CHANCES = 2;
    protected final AccessProcessor ap;
    protected final Task task;
    private final LinkedList<Integer> jobs;
    protected Job<?> currentJob;
    boolean cancelledBeforeSubmit = false;
    boolean extraResubmit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, AccessProcessor ap, Task task) {
        super(schedulingInformation, orchestrator);
        this.ap = ap;
        this.task = task;
        this.jobs = new LinkedList();
        this.task.addExecution(this);
        Task task2 = this.task;
        synchronized (task2) {
            this.registerDataDependencies();
            this.registerStreamProducers();
            this.registerMutex();
        }
        Task resourceConstraintTask = this.task.getEnforcingTask();
        if (resourceConstraintTask != null) {
            for (AllocatableAction e : resourceConstraintTask.getExecutions()) {
                this.addResourceConstraint(e);
            }
        }
    }

    private void registerMutex() {
        for (CommutativeGroupTask group : this.task.getCommutativeGroupList()) {
            ActionGroup.MutexGroup mGroup = group.getActions();
            this.addToMutexGroup(mGroup);
        }
    }

    private void registerStreamProducers() {
        for (AbstractTask predecessor : this.task.getStreamProducers()) {
            for (AllocatableAction e : ((Task)predecessor).getExecutions()) {
                if (e == null || !e.isPending()) continue;
                this.addStreamProducer(e);
            }
        }
    }

    private void registerDataDependencies() {
        List<AbstractTask> predecessors = this.task.getPredecessors();
        for (AbstractTask predecessor : predecessors) {
            if (!(predecessor instanceof CommutativeGroupTask)) {
                this.treatStandardPredecessor(predecessor);
                continue;
            }
            this.treatCommutativePredecessor((CommutativeGroupTask)predecessor);
        }
    }

    private void treatCommutativePredecessor(CommutativeGroupTask predecessor) {
        if (DEBUG) {
            LOGGER.debug("Task has a commutative group as a predecessor");
        }
        for (Task t : predecessor.getCommutativeTasks()) {
            for (AllocatableAction com : t.getExecutions()) {
                if (com.getDataPredecessors().contains(this)) continue;
                this.addDataPredecessor(com);
            }
        }
    }

    private void treatStandardPredecessor(AbstractTask predecessor) {
        for (AllocatableAction e : predecessor.getExecutions()) {
            if (e != null && e.isPending()) {
                this.addDataPredecessor(e);
                continue;
            }
            this.addAlreadyDoneAction(e);
        }
    }

    public final Task getTask() {
        return this.task;
    }

    @Override
    public boolean isToReserveResources() {
        return true;
    }

    @Override
    public boolean isToReleaseResources() {
        return true;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onSubmission();
        if (!this.cancelledBeforeSubmit) {
            this.currentJob = this.createJob();
            this.jobs.add(this.currentJob.getJobId());
            this.currentJob.stageIn();
            this.task.setSubmitted();
        } else {
            this.jobCancelled(null);
        }
    }

    private Job<?> createJob() {
        if (DEBUG) {
            LOGGER.debug(this.toString() + " starts job creation");
        }
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        List<String> slaveNames = this.getSlaveNames();
        ArrayList<Integer> predecessors = null;
        if (Tracer.isActivated() && Tracer.isTracingTaskDependencies()) {
            predecessors = Tracer.getPredecessors(this.task.getId());
        }
        Job<?> job = w.newJob(this.task.getId(), this.task.getTaskDescription(), this.getAssignedImplementation(), slaveNames, this, predecessors, this.task.getSuccessors().size());
        LOGGER.info((this.getExecutingResources().size() > 1 ? "Rescheduled" : "New") + " Job " + job.getJobId() + " (Task: " + this.task.getId() + ")");
        LOGGER.info("  * Method name: " + this.task.getTaskDescription().getName());
        LOGGER.info("  * Target host: " + this.getAssignedResource().getName());
        if (Tracer.isActivated() && Tracer.isTracingTaskDependencies()) {
            Tracer.removePredecessor(this.task.getId());
        }
        return job;
    }

    @Override
    public boolean checkIfCanceled(AllocatableAction aa) {
        return aa instanceof ExecutionAction && ((ExecutionAction)aa).getTask().getStatus() == TaskState.CANCELED;
    }

    @Override
    public final void stageInFailed(int failedtransfers) {
        int taskId = this.task.getId();
        String workerName = this.getAssignedResource().getName();
        ErrorManager.warn("Transfers for running task " + taskId + " on worker " + workerName + " have failed.");
        this.notifyError();
    }

    @Override
    public final void stageInCompleted() {
        this.currentJob.submit();
    }

    @Override
    public void submitted(Job<?> job) {
        this.submittedAt(job, System.currentTimeMillis());
    }

    @Override
    public void submittedAt(Job<?> job, long ts) {
        this.profile.setSubmissionTime(ts);
    }

    @Override
    public void arrived(Job<?> job) {
        this.arrivedAt(job, System.currentTimeMillis());
    }

    @Override
    public void arrivedAt(Job<?> job, long ts) {
        this.profile.setArrivalTime(ts);
    }

    protected List<String> getSlaveNames() {
        return new ArrayList<String>();
    }

    @Override
    public void allInputDataOnWorker(Job<?> job) {
        this.allInputDataOnWorkerAt(job, System.currentTimeMillis());
    }

    @Override
    public void allInputDataOnWorkerAt(Job<?> job, long ts) {
        this.profile.setDataFetchingTime(ts);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onDataReception();
    }

    @Override
    public void startingExecution(Job<?> job) {
        this.startingExecutionAt(job, System.currentTimeMillis());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onExecutionStart();
    }

    @Override
    public void startingExecutionAt(Job<?> job, long ts) {
        this.profile.setExecutionStartTime(ts);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onExecutionStartAt(ts);
    }

    @Override
    public void endedExecution(Job<?> job) {
        this.endedExecutionAt(job, System.currentTimeMillis());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onExecutionEnd();
    }

    @Override
    public void endedExecutionAt(Job<?> job, long ts) {
        this.profile.setExecutionEndTime(ts);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onExecutionEndAt(ts);
    }

    @Override
    public void endNotified(Job<?> job) {
        this.endNotifiedAt(job, System.currentTimeMillis());
    }

    @Override
    public void endNotifiedAt(Job<?> job, long ts) {
        this.profile.setEndNotificationTime(ts);
    }

    @Override
    protected void stopAction() throws Exception {
        if (DEBUG) {
            LOGGER.debug("Task " + this.task.getId() + " starts cancelling running job");
        }
        if (this.currentJob != null) {
            this.currentJob.cancel();
        } else {
            this.cancelledBeforeSubmit = true;
        }
    }

    @Override
    public final void jobCancelled(Job<?> job) {
        this.notifyError();
    }

    @Override
    public final void jobException(Job<?> job, COMPSsException e) {
        LOGGER.debug("Job " + job.getJobId() + " raised an Exception");
        this.profile.end(System.currentTimeMillis());
        if (e instanceof COMPSsException && this.task.hasTaskGroups()) {
            for (TaskGroup t : this.task.getTaskGroupList()) {
                t.setException(e);
            }
        }
        this.notifyException(e);
    }

    @Override
    public final void jobFailed(Job<?> job, JobEndStatus status) {
        LOGGER.debug("Job " + job.getJobId() + " failed");
        this.profile.end(System.currentTimeMillis());
        this.notifyError();
    }

    @Override
    public final void jobCompleted(Job<?> job) {
        LOGGER.debug("Job " + job.getJobId() + " completed");
        this.profile.end(System.currentTimeMillis());
        this.notifyCompleted();
    }

    @Override
    public void resultAvailable(Parameter p, String dataName) {
        if (p.isPotentialDependency()) {
            DependencyParameter dp = (DependencyParameter)p;
            if (dp.getDirection() == Direction.COMMUTATIVE) {
                EngineDataAccessId placeHolder = dp.getDataAccessId();
                CommutativeGroupTask cgt = this.getTask().getCommutativeGroup(placeHolder.getDataId());
                EngineDataAccessId performedAccess = cgt.nextAccess();
                dp.setDataAccessId(performedAccess);
            }
            p.getMonitor().onCreation(p.getType(), dataName);
        }
    }

    @Override
    protected void doCompleted() {
        this.getAssignedResource().profiledExecution(this.getAssignedImplementation(), this.profile);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onSuccesfulExecution();
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FINISHED);
        this.ap.notifyTaskEnd(this.task);
    }

    @Override
    protected void doError() throws FailedActionException {
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onErrorExecution();
        if (this.task.getOnFailure() == OnFailure.RETRY) {
            if (this.getExecutingResources().size() >= 2) {
                LOGGER.warn("Task " + this.task.getId() + " has already been rescheduled; notifying task failure.");
                ErrorManager.warn("Task " + this.task.getId() + " has already been rescheduled; notifying task failure.");
                throw new FailedActionException();
            }
        } else {
            LOGGER.warn("Notifying task " + this.task.getId() + " failure");
            ErrorManager.warn("Notifying task " + this.task.getId() + " failure");
            throw new FailedActionException();
        }
        ErrorManager.warn("Task " + this.task.getId() + " execution on worker " + this.getAssignedResource().getName() + " has failed; rescheduling task execution. (changing worker)");
        LOGGER.warn("Task " + this.task.getId() + " execution on worker " + this.getAssignedResource().getName() + " has failed; rescheduling task execution. (changing worker)");
    }

    @Override
    protected void doAbort() {
        ResourceScheduler<? extends WorkerResourceDescription> target = this.getAssignedResource();
        if (target != null) {
            this.getExecutingResources().remove(target);
        }
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onAbortedExecution();
    }

    @Override
    protected void doFailed() {
        String taskName = this.task.getTaskDescription().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("Task '").append(taskName).append("' TOTALLY FAILED.\n");
        sb.append("Possible causes:\n");
        sb.append("     -Exception thrown by task '").append(taskName).append("'.\n");
        sb.append("     -Expected output files not generated by task '").append(taskName).append("'.\n");
        sb.append("     -Could not provide nor retrieve needed data between master and worker.\n");
        sb.append("\n");
        sb.append("Check files '").append(LoggerManager.getJobsLogDir()).append("job[");
        Iterator j = this.jobs.iterator();
        while (j.hasNext()) {
            sb.append(j.next());
            if (!j.hasNext()) break;
            sb.append("|");
        }
        sb.append("'] to find out the error.\n");
        sb.append(" \n");
        ErrorManager.warn(sb.toString());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onFailedExecution();
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FAILED);
        this.ap.notifyTaskEnd(this.task);
    }

    @Override
    protected Collection<AllocatableAction> doException(COMPSsException e) {
        LinkedList<TaskGroup> taskGroups = this.task.getTaskGroupList();
        LinkedList<AllocatableAction> otherActionsFromGroups = new LinkedList<AllocatableAction>();
        for (TaskGroup group : taskGroups) {
            if (group.getName().equals("App" + this.task.getApplication().getId())) continue;
            group.setException(e);
            group.addToCollectionExecutionForTasksOtherThan(otherActionsFromGroups, this.getTask());
        }
        String taskName = this.task.getTaskDescription().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("COMPSs Exception raised : Task " + this.task.getId() + " (").append(taskName).append(") has raised an exception with message ").append(e.getMessage()).append(". Members of the containing groups will be cancelled.\n");
        sb.append("\n");
        ErrorManager.warn(sb.toString());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onException(e);
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FINISHED);
        this.ap.notifyTaskEnd(this.task);
        return otherActionsFromGroups;
    }

    @Override
    protected boolean doCanceled() {
        String taskName = this.task.getTaskDescription().getName();
        ErrorManager.warn("Task " + this.task.getId() + "(Action: " + this.getId() + ") with name " + taskName + " has been cancelled.");
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.CANCELED);
        this.ap.notifyTaskEnd(this.task);
        return !this.task.getOnFailure().equals((Object)OnFailure.IGNORE);
    }

    @Override
    protected void doFailIgnored() {
        String taskName = this.task.getTaskDescription().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("Task failure: Task " + this.task.getId() + " (").append(taskName).append(") has failed. Successors keep running.\n");
        sb.append("\n");
        ErrorManager.warn(sb.toString());
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onFailedExecution();
        this.task.decreaseExecutionCount();
        this.task.setStatus(TaskState.FINISHED);
        this.ap.notifyTaskEnd(this.task);
    }

    @Override
    public final List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        return this.getCoreElementExecutors(this.task.getTaskDescription().getCoreElement().getCoreId());
    }

    @Override
    public final Implementation[] getImplementations() {
        CoreElement ce = this.task.getTaskDescription().getCoreElement();
        List<Implementation> coreImpls = ce.getImplementations();
        int coreImplsSize = coreImpls.size();
        Implementation[] impls = new Implementation[coreImplsSize];
        for (int i = 0; i < coreImplsSize; ++i) {
            impls[i] = coreImpls.get(i);
        }
        return impls;
    }

    @Override
    public <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> r) {
        return r.canRun(this.task.getTaskDescription().getCoreElement().getCoreId());
    }

    @Override
    public final <T extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<T> r) {
        return r.getExecutableImpls(this.task.getTaskDescription().getCoreElement().getCoreId());
    }

    @Override
    public final Integer getCoreId() {
        return this.task.getTaskDescription().getCoreElement().getCoreId();
    }

    @Override
    public final int getPriority() {
        return this.task.getTaskDescription().hasPriority() ? 1 : 0;
    }

    @Override
    public long getGroupPriority() {
        return Long.MAX_VALUE;
    }

    @Override
    public OnFailure getOnFailure() {
        return this.task.getOnFailure();
    }

    @Override
    public final <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> targetWorker, Score actionScore) {
        return targetWorker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        List<Object> candidates = new LinkedList();
        List<ResourceScheduler<? extends WorkerResourceDescription>> compatibleWorkers = this.getCompatibleWorkers();
        if (this.isTargetResourceEnforced()) {
            ResourceScheduler<? extends WorkerResourceDescription> target = this.getEnforcedTargetResource();
            if (!compatibleWorkers.contains(target)) throw new UnassignedActionException();
            candidates.add(target);
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                ResourceScheduler<? extends WorkerResourceDescription> target = a.getAssignedResource();
                if (!compatibleWorkers.contains(target)) continue;
                candidates.add(target);
            }
        } else {
            candidates = compatibleWorkers;
        }
        if (candidates.isEmpty()) {
            throw new BlockedActionException();
        }
        List<ResourceScheduler<? extends WorkerResourceDescription>> prevExecutors = this.getExecutingResources();
        if (candidates.size() > prevExecutors.size() && prevExecutors.size() > 0) {
            candidates.removeAll(prevExecutors);
        }
        this.scheduleSecuredCandidates(actionScore, candidates);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void schedule(Collection<ResourceScheduler<? extends WorkerResourceDescription>> candidates, Score actionScore) throws UnassignedActionException {
        List<ResourceScheduler<? extends WorkerResourceDescription>> compatibleWorkers = this.getCompatibleWorkers();
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> verifiedCandidates = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        if (this.isTargetResourceEnforced()) {
            ResourceScheduler<? extends WorkerResourceDescription> target = this.getEnforcedTargetResource();
            if (!candidates.contains(target) || !compatibleWorkers.contains(target)) throw new UnassignedActionException();
            verifiedCandidates.add(target);
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                ResourceScheduler<? extends WorkerResourceDescription> target = a.getAssignedResource();
                if (!candidates.contains(target) || !compatibleWorkers.contains(target)) continue;
                verifiedCandidates.add(target);
            }
            if (verifiedCandidates.isEmpty()) {
                throw new UnassignedActionException();
            }
        } else {
            for (ResourceScheduler<? extends WorkerResourceDescription> candidate : candidates) {
                if (!compatibleWorkers.contains(candidate) || !compatibleWorkers.contains(candidate)) continue;
                verifiedCandidates.add(candidate);
            }
            if (verifiedCandidates.isEmpty()) {
                throw new UnassignedActionException();
            }
        }
        this.scheduleSecuredCandidates(actionScore, verifiedCandidates);
    }

    @Override
    public final void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Score actionScore) throws UnassignedActionException {
        if (targetWorker == null || !this.validateWorker(targetWorker)) {
            throw new UnassignedActionException();
        }
        Implementation bestImpl = null;
        Score bestScore = null;
        Score resourceScore = targetWorker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
        if (resourceScore != null) {
            for (Implementation impl : this.getCompatibleImplementations(targetWorker)) {
                Score implScore = targetWorker.generateImplementationScore(this, this.task.getTaskDescription(), impl, resourceScore);
                if (!Score.isBetter(implScore, bestScore)) continue;
                bestImpl = impl;
                bestScore = implScore;
            }
        }
        if (bestImpl == null) {
            throw new UnassignedActionException();
        }
        this.assignWorkerAndImpl(targetWorker, bestImpl);
    }

    @Override
    public final void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Implementation impl) throws UnassignedActionException {
        if (targetWorker == null || impl == null) {
            this.assignResource(null);
            throw new UnassignedActionException();
        }
        if (DEBUG) {
            LOGGER.debug("Scheduling " + this + " on worker " + targetWorker.getName() + " with implementation " + impl.getImplementationId());
        }
        if (!this.validateWorker(targetWorker)) {
            throw new UnassignedActionException();
        }
        if (!targetWorker.getResource().canRun(impl)) {
            LOGGER.warn("Worker " + targetWorker.getName() + " is not compatible with " + impl);
            throw new UnassignedActionException();
        }
        this.assignWorkerAndImpl(targetWorker, impl);
    }

    private boolean validateWorker(ResourceScheduler targetCandidate) {
        if (this.isTargetResourceEnforced()) {
            ResourceScheduler<? extends WorkerResourceDescription> enforcedTarget = this.getEnforcedTargetResource();
            if (enforcedTarget != targetCandidate) {
                LOGGER.warn("Task " + this.getTask().getId() + " is enforced to run on " + enforcedTarget.getName());
                return false;
            }
        } else if (this.isSchedulingConstrained()) {
            boolean isPredecessor = false;
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                ResourceScheduler<? extends WorkerResourceDescription> predecessorHost = a.getAssignedResource();
                if (targetCandidate != predecessorHost) continue;
                isPredecessor = true;
            }
            if (!isPredecessor) {
                LOGGER.warn(targetCandidate.getName() + " did not host the execution of any constraining predecessor");
                return false;
            }
        }
        if (this.getExecutingResources().contains(targetCandidate) && this.getCompatibleWorkers().size() > 1) {
            LOGGER.warn("Task " + this.getTask().getId() + " was already scheduled on " + targetCandidate.getName());
            return false;
        }
        return true;
    }

    private void scheduleSecuredCandidates(Score actionScore, List<ResourceScheduler<? extends WorkerResourceDescription>> candidates) throws UnassignedActionException {
        StringBuilder debugString = new StringBuilder("Scheduling " + this + " execution:\n");
        ResourceScheduler<? extends WorkerResourceDescription> bestWorker = null;
        Implementation bestImpl = null;
        Score bestScore = null;
        for (ResourceScheduler<? extends WorkerResourceDescription> worker : candidates) {
            Score resourceScore = worker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
            if (resourceScore == null) continue;
            for (Implementation impl : this.getCompatibleImplementations(worker)) {
                Score implScore = worker.generateImplementationScore(this, this.task.getTaskDescription(), impl, resourceScore);
                if (DEBUG) {
                    debugString.append("[Task ").append(this.task.getId()).append("] Resource ").append(worker.getName()).append(" ").append(" Implementation ").append(impl.getImplementationId()).append(" ").append(" Score ").append(implScore).append("\n");
                }
                if (!Score.isBetter(implScore, bestScore)) continue;
                bestWorker = worker;
                bestImpl = impl;
                bestScore = implScore;
            }
        }
        if (DEBUG) {
            LOGGER.debug(debugString.toString());
        }
        if (bestWorker == null) {
            throw new UnassignedActionException();
        }
        this.assignWorkerAndImpl(bestWorker, bestImpl);
    }

    private void assignWorkerAndImpl(ResourceScheduler worker, Implementation impl) {
        LOGGER.info("Assigning action " + this + " to worker " + worker.getName() + " with implementation " + impl.getImplementationId());
        this.assignImplementation(impl);
        this.assignResource(worker);
        worker.scheduleAction(this);
        TaskMonitor monitor = this.task.getTaskMonitor();
        monitor.onSchedule();
    }

    @Override
    public String toString() {
        String ceName = this.task.getTaskDescription().getName();
        return "ExecutionAction (Task " + this.task.getId() + ", CE name " + ceName + ")";
    }
}

