/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.ObjectAccessParams;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.StreamData;
import es.bsc.distrostreamlib.api.DistroStream;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.requests.AddStreamWriterRequest;

public class StreamAccessParams<T, D extends StreamData>
extends ObjectAccessParams<T, D> {
    private static final long serialVersionUID = 1L;

    public static final <T> StreamAccessParams<T, StreamData> constructStreamAP(Application app, Direction dir, T value, int code) {
        return new StreamAccessParams<T, StreamData>(app, new StreamData(code), dir, value);
    }

    protected StreamAccessParams(Application app, D data, Direction dir, T value) {
        super(app, data, dir, value);
    }

    @Override
    protected void registerValueForVersion(DataVersion dv) {
        EngineDataInstanceId lastDID = dv.getDataInstanceId();
        String renaming = lastDID.getRenaming();
        Comm.registerValue(renaming, this.getValue());
    }

    @Override
    protected void externalRegister() {
        if (this.mode != AccessParams.AccessMode.R) {
            DistroStream ds = (DistroStream)this.getValue();
            String streamId = ds.getId();
            if (DEBUG) {
                LOGGER.debug("Registering writer for stream " + streamId);
            }
            AddStreamWriterRequest req = new AddStreamWriterRequest(streamId);
            DistroStreamClient.request(req);
        }
    }
}

