/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.types.implementations.definition.CommonMPIDefinition;
import es.bsc.compss.types.resources.ContainerDescription;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class MPIDefinition
extends CommonMPIDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 8;
    public static final String SIGNATURE = "mpi.MPI";
    private static final String ERROR_MPI_BINARY = "ERROR: Empty binary annotation for MPI method";
    private String binary;
    private String params;
    private ContainerDescription container;

    public MPIDefinition() {
    }

    public MPIDefinition(String binary, String workingDir, String mpiRunner, int ppn, String mpiFlags, boolean scaleByCU, String params, boolean failByEV) {
        super(workingDir, mpiRunner, ppn, mpiFlags, scaleByCU, failByEV);
        this.binary = binary;
        this.params = params;
    }

    public MPIDefinition(String[] implTypeArgs, int offset, String[] container) {
        this.binary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.ppn = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]));
        this.mpiFlags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 4]);
        this.scaleByCU = Boolean.parseBoolean(implTypeArgs[offset + 5]);
        this.params = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 6]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 7]);
        if (container[0] != null && !container[0].isEmpty() && !container[0].equals("[unassigned]")) {
            String engineStr = container[0].toUpperCase();
            ContainerDescription.ContainerEngine engine = ContainerDescription.ContainerEngine.valueOf(engineStr);
            this.container = new ContainerDescription(engine, container[1], container[2]);
        } else {
            this.container = null;
        }
        this.checkArguments();
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.binary);
        lArgs.add(this.workingDir);
        lArgs.add(this.mpiRunner);
        lArgs.add(Integer.toString(this.ppn));
        lArgs.add(this.mpiFlags);
        lArgs.add(Boolean.toString(this.scaleByCU));
        lArgs.add(this.params);
        lArgs.add(Boolean.toString(this.failByEV));
    }

    public String getBinary() {
        return this.binary;
    }

    public String getParams() {
        return this.params;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MPI;
    }

    public ContainerDescription getContainer() {
        return this.container;
    }

    @Override
    public String toMethodDefinitionFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MPI RUNNER=").append(this.mpiRunner);
        sb.append(", MPI_PPN=").append(this.ppn);
        sb.append(", MPI_FLAGS=").append(this.mpiFlags);
        sb.append(", BINARY=").append(this.binary);
        sb.append(", PARAMS=").append(this.params);
        sb.append(", CONTAINER=").append(this.container);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return "MPI Method with binary " + this.binary + " and MPIrunner " + this.mpiRunner;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mpiRunner = (String)in.readObject();
        this.ppn = in.readInt();
        this.mpiFlags = (String)in.readObject();
        this.binary = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.scaleByCU = in.readBoolean();
        this.params = (String)in.readObject();
        this.failByEV = in.readBoolean();
        this.container = (ContainerDescription)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.mpiRunner);
        out.writeInt(this.ppn);
        out.writeObject(this.mpiFlags);
        out.writeObject(this.binary);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.scaleByCU);
        out.writeObject(this.params);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.container);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MPI Implementation \n");
        sb.append("\t Binary: ").append(this.binary).append("\n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t MPI PPN: ").append(this.ppn).append("\n");
        sb.append("\t MPI flags: ").append(this.mpiFlags).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Scale by Computing Units: ").append(this.scaleByCU).append("\n");
        sb.append("\t Params String: ").append(this.params).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Container: ").append(this.container).append("\n");
        return sb.toString();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    @Override
    public void checkArguments() {
        super.checkArguments();
        if (this.binary == null || this.binary.isEmpty()) {
            throw new IllegalArgumentException(ERROR_MPI_BINARY);
        }
    }

    public boolean hasParamsString() {
        return this.params != null && !this.params.equals("[unassigned]");
    }
}

