/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.parameter.impl;

import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.parameter.impl.Parameter;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DependencyParameter<T extends AccessParams>
extends Parameter
implements es.bsc.compss.types.parameter.DependencyParameter {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final T access;
    private EngineDataAccessId daId;
    private Object dataSource;
    private String dataTarget;

    protected DependencyParameter(T access, DataType type, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename, ParameterMonitor monitor) {
        super(type, direction, stream, prefix, name, contentType, weight, keepRename, monitor);
        this.access = access;
    }

    @Override
    public boolean isPotentialDependency() {
        return true;
    }

    public final T getAccess() {
        return this.access;
    }

    @Override
    public EngineDataAccessId getDataAccessId() {
        return this.daId;
    }

    public void setDataAccessId(EngineDataAccessId daId) {
        this.daId = daId;
    }

    @Override
    public String getOriginalName() {
        return "NO_NAME";
    }

    @Override
    public Object getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(Object dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getDataTarget() {
        return this.dataTarget;
    }

    @Override
    public void setDataTarget(String target) {
        this.dataTarget = target;
    }

    @Override
    public String generateDataTargetName(String tgtName) {
        if (this.getType().equals((Object)DataType.PSCO_T) || this.getType().equals((Object)DataType.EXTERNAL_PSCO_T)) {
            return this.getDataTarget();
        }
        return tgtName;
    }

    public String toString() {
        return "DependencyParameter";
    }

    @Override
    public boolean isSourcePreserved() {
        return this.daId.isPreserveSourceData();
    }

    @Override
    public boolean isTargetFlexible() {
        return true;
    }

    @Override
    public boolean register(Task task, boolean isConstraining) {
        boolean hasParamEdge = false;
        T access = this.getAccess();
        EngineDataAccessId daId = ((AccessParams)access).register();
        this.setDataAccessId(daId);
        hasParamEdge = this.addDependencies(task, isConstraining, this);
        return hasParamEdge;
    }

    @Override
    public void cancel(Task task) {
        EngineDataAccessId dAccId = this.getDataAccessId();
        this.updateParameter(task);
        dAccId.cancel(task.wasSubmited());
    }

    @Override
    public void commit(Task task) {
        EngineDataAccessId dAccId = this.getDataAccessId();
        this.updateParameter(task);
        dAccId.commit();
    }

    @Override
    public DataInfo removeData() throws ValueUnawareRuntimeException {
        T access = this.getAccess();
        Application app = ((AccessParams)access).getApp();
        return ((DataParams)((AccessParams)access).getData()).delete(app);
    }

    private boolean addDependencies(Task currentTask, boolean isConstraining, DependencyParameter dp) {
        boolean hasParamEdge = false;
        EngineDataAccessId daId = dp.getDataAccessId();
        int dataId = daId.getDataId();
        DataInfo di = dp.getDataAccessId().getAccessedDataInfo();
        switch (((AccessParams)dp.getAccess()).getMode()) {
            case R: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, di, isConstraining);
                break;
            }
            case RW: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, di, isConstraining);
                this.registerOutputValues(currentTask, dp, false, di);
                break;
            }
            case W: {
                this.registerOutputValues(currentTask, dp, false, di);
                break;
            }
            case C: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, true, dataId, di, isConstraining);
                this.registerOutputValues(currentTask, dp, true, di);
                break;
            }
            case CV: {
                hasParamEdge = this.checkInputDependency(currentTask, dp, false, dataId, di, isConstraining);
                this.registerOutputValues(currentTask, dp, false, di);
            }
        }
        return hasParamEdge;
    }

    private boolean checkInputDependency(Task currentTask, DependencyParameter dp, boolean isConcurrent, int dataId, DataInfo di, boolean isConstraining) {
        if (DEBUG) {
            LOGGER.debug("Checking READ dependency for datum " + dataId + " and task " + currentTask.getId());
        }
        boolean hasEdge = false;
        if (di != null) {
            hasEdge = di.readValue(currentTask, dp, isConcurrent);
            if (isConstraining) {
                AbstractTask lastWriter = di.getLastVersionProducer();
                currentTask.setEnforcingTask((Task)lastWriter);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            currentTask.registerFreeParam(dp);
        }
        return hasEdge;
    }

    private void registerOutputValues(Task currentTask, DependencyParameter dp, boolean isConcurrent, DataInfo di) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        if (DEBUG) {
            LOGGER.debug("Checking WRITE dependency for datum " + dataId + " and task " + currentTaskId);
        }
        di.writeValue(currentTask, dp, isConcurrent);
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dataId + " is task " + currentTaskId);
        }
    }

    private void updateParameter(Task task) {
        EngineDataAccessId dAccId = this.getDataAccessId();
        if (dAccId == null) {
            LOGGER.warn("Parameter for task " + task.getId() + " has no access ID. It could be from a cancelled type. Ignoring ... ");
            return;
        }
        int dataId = dAccId.getDataId();
        if (DEBUG) {
            int currentTaskId = task.getId();
            LOGGER.debug("Removing writters info for datum " + dataId + " and task " + currentTaskId);
        }
        switch (this.getDirection()) {
            case OUT: 
            case INOUT: {
                DataInfo di = dAccId.getAccessedDataInfo();
                di.completedProducer(task);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("Treating that data " + dAccId + " has been accessed at " + this.getDataTarget());
        }
    }
}

