/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.logging.log4j.Logger;

public class FileOperations {
    public static void copyFile(File source, File target, Logger logger) throws IOException {
        Path sourcePath;
        Path tgtPath = target.toPath();
        if (tgtPath.compareTo(sourcePath = source.toPath()) != 0) {
            try {
                Files.copy(sourcePath, tgtPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (DirectoryNotEmptyException dne) {
                FileOperations.deleteDirectoryContent(tgtPath, logger);
            }
            Files.walk(sourcePath, new FileVisitOption[0]).forEach(content -> {
                try {
                    Path fileDest = tgtPath.resolve(sourcePath.relativize((Path)content));
                    Files.copy(content, fileDest, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    logger.error("Exception copying file " + content + " to " + tgtPath);
                }
            });
        }
    }

    public static void deleteFile(File f, Logger logger) throws IOException {
        Path directory = f.toPath();
        try {
            if (!Files.deleteIfExists(directory) && logger != null) {
                logger.debug("File " + f.getAbsolutePath() + " not deleted.");
            }
        }
        catch (DirectoryNotEmptyException dne) {
            FileOperations.deleteDirectoryContent(directory, logger);
            try {
                Files.delete(directory);
            }
            catch (NoSuchFileException e) {
                return;
            }
        }
    }

    private static void deleteDirectoryContent(Path directory, Logger logger) throws IOException {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (logger != null) {
                logger.error("Cannot delete directory " + directory, (Throwable)e);
            }
            throw e;
        }
    }

    public static void moveFile(File source, File target, Logger logger) throws DirectoryNotEmptyException, IOException {
        Path sourcePath;
        Path tgtPath = target.toPath();
        if (tgtPath.compareTo(sourcePath = source.toPath()) != 0) {
            try {
                Files.move(sourcePath, tgtPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException amnse) {
                logger.warn("WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic");
                Files.move(sourcePath, tgtPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

